/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;

public class SelectionMapper {
    private ListSelectionModel viewSelection;
    protected DefaultListSelectionModel modelSelection = new DefaultListSelectionModel();
    private FilterPipeline pipeline;
    private ListSelectionListener viewSelectionListener;
    private boolean isListening;
    private PipelineListener pipelineListener;

    public SelectionMapper(FilterPipeline filterPipeline, ListSelectionModel listSelectionModel) {
        this.setViewSelectionModel(listSelectionModel);
        this.setFilters(filterPipeline);
    }

    public void setViewSelectionModel(ListSelectionModel listSelectionModel) {
        ListSelectionModel listSelectionModel2 = this.viewSelection;
        if (listSelectionModel2 != null) {
            listSelectionModel2.removeListSelectionListener(this.viewSelectionListener);
            this.clearModelSelection();
        }
        this.viewSelection = listSelectionModel;
        this.mapTowardsModel();
        this.viewSelection.addListSelectionListener(this.getViewSelectionListener());
        this.isListening = true;
    }

    public void setFilters(FilterPipeline filterPipeline) {
        FilterPipeline filterPipeline2 = this.pipeline;
        if (filterPipeline2 != null) {
            filterPipeline2.removePipelineListener(this.pipelineListener);
        }
        this.pipeline = filterPipeline;
        if (filterPipeline != null) {
            filterPipeline.addPipelineListener(this.getPipelineListener());
        }
        this.restoreSelection();
    }

    public void restoreSelection() {
        int n;
        this.lock();
        this.clearViewSelection();
        int[] nArray = this.getSelectedRows(this.modelSelection);
        for (n = 0; n < nArray.length; ++n) {
            int n2 = this.convertToView(nArray[n]);
            this.viewSelection.addSelectionInterval(n2, n2);
        }
        n = this.modelSelection.getLeadSelectionIndex();
        if (n >= 0) {
            n = this.convertToView(n);
        }
        if (this.viewSelection instanceof DefaultListSelectionModel) {
            ((DefaultListSelectionModel)this.viewSelection).moveLeadSelectionIndex(n);
        } else {
            this.viewSelection.removeSelectionInterval(n, n);
            this.viewSelection.addSelectionInterval(n, n);
        }
        this.unlock();
    }

    public void unlock() {
        if (!this.isListening) {
            this.viewSelection.setValueIsAdjusting(false);
            this.viewSelection.addListSelectionListener(this.getViewSelectionListener());
            this.isListening = true;
        }
    }

    public void lock() {
        if (this.isListening) {
            this.viewSelection.removeListSelectionListener(this.viewSelectionListener);
            this.viewSelection.setValueIsAdjusting(true);
            this.isListening = false;
        }
    }

    public void clearModelSelection() {
        this.modelSelection.clearSelection();
        this.modelSelection.setAnchorSelectionIndex(-1);
        this.modelSelection.setLeadSelectionIndex(-1);
    }

    private void clearViewSelection() {
        this.viewSelection.clearSelection();
    }

    public void insertIndexInterval(int n, int n2, boolean bl) {
        this.modelSelection.insertIndexInterval(n, n2, bl);
    }

    public void removeIndexInterval(int n, int n2) {
        this.modelSelection.removeIndexInterval(n, n2);
    }

    private void mapTowardsModel() {
        this.clearModelSelection();
        int[] nArray = this.getSelectedRows(this.viewSelection);
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.convertToModel(nArray[i]);
            this.modelSelection.addSelectionInterval(n, n);
        }
        if (nArray.length > 0) {
            this.modelSelection.moveLeadSelectionIndex(this.convertToModel(this.viewSelection.getLeadSelectionIndex()));
        }
    }

    private int convertToModel(int n) {
        return this.pipeline != null && this.pipeline.isAssigned() ? this.pipeline.convertRowIndexToModel(n) : n;
    }

    private int convertToView(int n) {
        return this.pipeline != null && this.pipeline.isAssigned() ? this.pipeline.convertRowIndexToView(n) : n;
    }

    protected void updateFromViewSelectionChanged(int n, int n2) {
        int n3;
        for (n3 = n; n3 <= n2; ++n3) {
            int n4 = this.convertToModel(n3);
            if (this.viewSelection.isSelectedIndex(n3)) {
                this.modelSelection.addSelectionInterval(n4, n4);
                continue;
            }
            this.modelSelection.removeSelectionInterval(n4, n4);
        }
        n3 = this.viewSelection.getLeadSelectionIndex();
        if (n3 >= 0) {
            this.modelSelection.moveLeadSelectionIndex(this.convertToModel(n3));
        }
    }

    protected void updateFromPipelineChanged() {
        this.restoreSelection();
    }

    private int[] getSelectedRows(ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n == -1 || n2 == -1) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private PipelineListener getPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = new PipelineListener(){

                public void contentsChanged(PipelineEvent pipelineEvent) {
                    SelectionMapper.this.updateFromPipelineChanged();
                }
            };
        }
        return this.pipelineListener;
    }

    private ListSelectionListener getViewSelectionListener() {
        if (this.viewSelectionListener == null) {
            this.viewSelectionListener = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    SelectionMapper.this.updateFromViewSelectionChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex());
                }
            };
        }
        return this.viewSelectionListener;
    }
}

