/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jdesktop.swingx.autocomplete.AbstractComponentAdaptor;

public class Document
extends PlainDocument {
    boolean selecting = false;
    boolean strictMatching;
    AbstractComponentAdaptor adaptor;

    public Document(AbstractComponentAdaptor abstractComponentAdaptor, boolean bl) {
        this.adaptor = abstractComponentAdaptor;
        this.strictMatching = bl;
        Object object = abstractComponentAdaptor.getSelectedItem();
        if (object != null) {
            this.setText(object.toString());
        }
        abstractComponentAdaptor.markEntireText();
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.remove(n, n2);
        if (!this.strictMatching) {
            this.setSelectedItem(this.getText(0, this.getLength()));
            this.adaptor.getTextComponent().setCaretPosition(n);
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(n, string, attributeSet);
        Object object = this.lookupItem(this.getText(0, this.getLength()));
        if (object != null) {
            this.setSelectedItem(object);
        } else if (this.strictMatching) {
            object = this.adaptor.getSelectedItem();
            n -= string.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.adaptor.getTextComponent());
        } else {
            object = this.getText(0, this.getLength());
            this.setSelectedItem(object);
        }
        this.setText(object == null ? "" : object.toString());
        this.adaptor.markText(n + string.length());
    }

    private void setText(String string) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    private void setSelectedItem(Object object) {
        this.selecting = true;
        this.adaptor.setSelectedItem(object);
        this.selecting = false;
    }

    private Object lookupItem(String string) {
        Object object = this.adaptor.getSelectedItem();
        if (object != null && this.startsWithIgnoreCase(object.toString(), string)) {
            return object;
        }
        int n = this.adaptor.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object object2 = this.adaptor.getItem(i);
            if (object2 == null || !this.startsWithIgnoreCase(object2.toString(), string)) continue;
            return object2;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }
}

