/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.jdesktop.swingx.LinkModel;

public class LinkAction
extends AbstractAction {
    private LinkModel link;
    private ActionListener delegate;
    public static final String VISIT_ACTION = "visit";
    public static final String VISITED_PROPERTY = "visited";
    private PropertyChangeListener linkListener;

    public LinkAction(LinkModel linkModel) {
        this.setLink(linkModel);
    }

    public void setLink(LinkModel linkModel) {
        this.uninstallLinkListener();
        this.link = linkModel;
        this.installLinkListener();
        this.updateFromLink();
    }

    public LinkModel getLink() {
        return this.link;
    }

    public void setVisitingDelegate(ActionListener actionListener) {
        this.delegate = actionListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.delegate != null && this.link != null) {
            this.delegate.actionPerformed(new ActionEvent(this.link, 1001, VISIT_ACTION));
        }
    }

    private void uninstallLinkListener() {
        if (this.link == null) {
            return;
        }
        this.link.removePropertyChangeListener(this.getLinkListener());
    }

    private void updateFromLink() {
        if (this.link != null) {
            this.putValue("Name", this.link.getText());
            this.putValue("ShortDescription", this.link.getURL().toString());
            this.putValue(VISITED_PROPERTY, new Boolean(this.link.getVisited()));
        } else {
            Object[] objectArray = this.getKeys();
            if (objectArray == null) {
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                this.putValue(objectArray[i].toString(), null);
            }
        }
    }

    private void installLinkListener() {
        if (this.link == null) {
            return;
        }
        this.link.addPropertyChangeListener(this.getLinkListener());
    }

    private PropertyChangeListener getLinkListener() {
        if (this.linkListener == null) {
            this.linkListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LinkAction.this.updateFromLink();
                }
            };
        }
        return this.linkListener;
    }
}

