/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.action.LinkAction;

public class LinkRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ListCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private JXHyperlink linkButton;
    private LinkAction linkAction = new LinkAction(null);

    public LinkRenderer() {
        this(null);
    }

    public LinkRenderer(ActionListener actionListener) {
        this.linkButton = this.createHyperlink(this.linkAction);
        this.linkButton.addActionListener(this.createEditorActionListener());
        this.setVisitingDelegate(actionListener);
    }

    private JXHyperlink createHyperlink(Action action) {
        return new JXHyperlink(action){

            public void updateUI() {
                super.updateUI();
                this.setBorderPainted(true);
                this.setOpaque(true);
            }
        };
    }

    public void setVisitingDelegate(ActionListener actionListener) {
        this.linkAction.setVisitingDelegate(actionListener);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.linkAction.setLink(object instanceof LinkModel ? (LinkModel)object : null);
        Point point = (Point)jList.getClientProperty("swingx.rollover");
        if (point != null && point.y >= 0 && point.y == n) {
            this.linkButton.getModel().setRollover(true);
        } else {
            this.linkButton.getModel().setRollover(false);
        }
        this.updateSelectionColors(jList, bl);
        this.updateFocusBorder(bl2);
        return this.linkButton;
    }

    private void updateSelectionColors(JList jList, boolean bl) {
        if (bl) {
            this.linkButton.setBackground(jList.getSelectionBackground());
        } else {
            this.linkButton.setBackground(jList.getBackground());
        }
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.linkAction.setLink(object instanceof LinkModel ? (LinkModel)object : null);
        Point point = (Point)jTable.getClientProperty("swingx.rollover");
        if (point != null && point.x >= 0 && point.x == n2 && point.y == n) {
            this.linkButton.getModel().setRollover(true);
        } else {
            this.linkButton.getModel().setRollover(false);
        }
        this.updateSelectionColors(jTable, bl);
        this.updateFocusBorder(bl2);
        return this.linkButton;
    }

    private void updateSelectionColors(JTable jTable, boolean bl) {
        if (bl) {
            this.linkButton.setBackground(jTable.getSelectionBackground());
        } else {
            this.linkButton.setBackground(jTable.getBackground());
        }
    }

    private void updateFocusBorder(boolean bl) {
        if (bl) {
            this.linkButton.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.linkButton.setBorder(noFocusBorder);
        }
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.linkAction.setLink(object instanceof LinkModel ? (LinkModel)object : null);
        this.linkButton.getModel().setRollover(true);
        this.updateSelectionColors(jTable, bl);
        return this.linkButton;
    }

    public Object getCellEditorValue() {
        return this.linkAction.getLink();
    }

    private ActionListener createEditorActionListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LinkRenderer.this.fireEditingStopped();
            }
        };
        return actionListener;
    }
}

