/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.plaf.JXTaskPaneAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class JXTaskPane
extends JPanel
implements JXCollapsiblePane.JCollapsiblePaneContainer {
    public static final String uiClassID = "swingx/TaskPaneUI";
    public static final String EXPANDED_CHANGED_KEY = "expanded";
    public static final String SCROLL_ON_EXPAND_CHANGED_KEY = "scrollOnExpand";
    public static final String TITLE_CHANGED_KEY = "title";
    public static final String ICON_CHANGED_KEY = "icon";
    public static final String SPECIAL_CHANGED_KEY = "special";
    public static final String ANIMATED_CHANGED_KEY = "animated";
    private String title;
    private Icon icon;
    private boolean special;
    private boolean expanded = true;
    private boolean scrollOnExpand;
    private JXCollapsiblePane collapsePane = new JXCollapsiblePane();

    public JXTaskPane() {
        super.setLayout(new BorderLayout(0, 0));
        super.addImpl(this.collapsePane, "Center", -1);
        this.updateUI();
        this.setFocusable(true);
        this.setOpaque(false);
        this.setAnimated(!Boolean.FALSE.equals(UIManager.get("TaskPane.animate")));
        this.collapsePane.addPropertyChangeListener("animationState", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXTaskPane.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
    }

    public Container getContentPane() {
        return this.collapsePane.getContentPane();
    }

    public void updateUI() {
        if (this.collapsePane == null) {
            return;
        }
        this.setUI((TaskPaneUI)LookAndFeelAddons.getUI(this, TaskPaneUI.class));
    }

    public void setUI(TaskPaneUI taskPaneUI) {
        super.setUI(taskPaneUI);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(TITLE_CHANGED_KEY, string2, string);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.icon;
        this.icon = icon;
        this.firePropertyChange(ICON_CHANGED_KEY, icon2, icon);
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setSpecial(boolean bl) {
        if (this.special != bl) {
            this.special = bl;
            this.firePropertyChange(SPECIAL_CHANGED_KEY, !bl, bl);
        }
    }

    public void setScrollOnExpand(boolean bl) {
        if (this.scrollOnExpand != bl) {
            this.scrollOnExpand = bl;
            this.firePropertyChange(SCROLL_ON_EXPAND_CHANGED_KEY, !bl, bl);
        }
    }

    public boolean isScrollOnExpand() {
        return this.scrollOnExpand;
    }

    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            this.expanded = bl;
            this.collapsePane.setCollapsed(!bl);
            this.firePropertyChange(EXPANDED_CHANGED_KEY, !bl, bl);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setAnimated(boolean bl) {
        if (this.isAnimated() != bl) {
            this.collapsePane.setAnimated(bl);
            this.firePropertyChange(ANIMATED_CHANGED_KEY, !this.isAnimated(), this.isAnimated());
        }
    }

    public boolean isAnimated() {
        return this.collapsePane.isAnimated();
    }

    public Component add(Action action) {
        Component component = ((TaskPaneUI)this.ui).createAction(action);
        this.add(component);
        return component;
    }

    public Container getValidatingContainer() {
        return this.getParent();
    }

    protected void addImpl(Component component, Object object, int n) {
        this.getContentPane().add(component, object, n);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.collapsePane != null) {
            this.getContentPane().setLayout(layoutManager);
        }
    }

    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    public void remove(int n) {
        this.getContentPane().remove(n);
    }

    public void removeAll() {
        this.getContentPane().removeAll();
    }

    protected String paramString() {
        return super.paramString() + ",title=" + this.getTitle() + ",icon=" + this.getIcon() + ",expanded=" + String.valueOf(this.isExpanded()) + ",special=" + String.valueOf(this.isSpecial()) + ",scrollOnExpand=" + String.valueOf(this.isScrollOnExpand()) + ",ui=" + this.getUI();
    }

    static {
        LookAndFeelAddons.contribute(new JXTaskPaneAddon());
    }
}

