/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.PatternModel;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public abstract class AbstractPatternPanel
extends JXPanel {
    public static final String SEARCH_FIELD_LABEL = "searchFieldLabel";
    public static final String SEARCH_FIELD_MNEMONIC = "searchFieldLabel.mnemonic";
    public static final String SEARCH_TITLE = "searchTitle";
    public static final String MATCH_ACTION_COMMAND = "match";
    protected JLabel searchLabel;
    protected JTextField searchField;
    protected JCheckBox matchCheck;
    protected PatternModel patternModel;
    private ActionContainerFactory actionFactory;

    public abstract void match();

    protected AbstractActionExt getAction(String string) {
        return (AbstractActionExt)this.getActionMap().get(string);
    }

    protected void initActions() {
        this.initPatternActions();
        this.initExecutables();
    }

    protected void initExecutables() {
        AbstractActionExt abstractActionExt = this.createBoundAction(MATCH_ACTION_COMMAND, MATCH_ACTION_COMMAND);
        this.getActionMap().put("execute", abstractActionExt);
        this.getActionMap().put(MATCH_ACTION_COMMAND, abstractActionExt);
        this.refreshEmptyFromModel();
    }

    protected void initPatternActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("matchCase", this.createModelStateAction("matchCase", "setCaseSensitive", this.getPatternModel().isCaseSensitive()));
        actionMap.put("wrapSearch", this.createModelStateAction("wrapSearch", "setWrapping", this.getPatternModel().isWrapping()));
        actionMap.put("backwardsSearch", this.createModelStateAction("backwardsSearch", "setBackwards", this.getPatternModel().isBackwards()));
        actionMap.put("matchIncremental", this.createModelStateAction("matchIncremental", "setIncremental", this.getPatternModel().isIncremental()));
    }

    protected String getUIString(String string) {
        String string2 = UIManager.getString("Search." + string);
        return string2 != null ? string2 : string;
    }

    protected AbstractActionExt createModelStateAction(String string, String string2, boolean bl) {
        String string3 = this.getUIString(string);
        BoundAction boundAction = new BoundAction(string3, string);
        boundAction.setStateAction();
        boundAction.registerCallback(this.getPatternModel(), string2);
        boundAction.setSelected(bl);
        return boundAction;
    }

    protected AbstractActionExt createBoundAction(String string, String string2) {
        String string3 = this.getUIString(string);
        BoundAction boundAction = new BoundAction(string3, string);
        boundAction.registerCallback(this, string2);
        return boundAction;
    }

    protected void refreshPatternFromModel() {
        if (this.getPatternModel().isIncremental()) {
            this.match();
        }
    }

    protected PatternModel getPatternModel() {
        if (this.patternModel == null) {
            this.patternModel = this.createPatternModel();
            this.patternModel.addPropertyChangeListener(this.getPatternModelListener());
        }
        return this.patternModel;
    }

    protected PatternModel createPatternModel() {
        PatternModel patternModel = new PatternModel();
        return patternModel;
    }

    protected PropertyChangeListener getPatternModelListener() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("pattern".equals(string)) {
                    AbstractPatternPanel.this.refreshPatternFromModel();
                } else if ("rawText".equals(string)) {
                    AbstractPatternPanel.this.refreshDocumentFromModel();
                } else if ("caseSensitive".equals(string)) {
                    AbstractPatternPanel.this.getAction("matchCase").setSelected((Boolean)propertyChangeEvent.getNewValue());
                } else if ("wrapping".equals(string)) {
                    AbstractPatternPanel.this.getAction("wrapSearch").setSelected((Boolean)propertyChangeEvent.getNewValue());
                } else if ("backwards".equals(string)) {
                    AbstractPatternPanel.this.getAction("backwardsSearch").setSelected((Boolean)propertyChangeEvent.getNewValue());
                } else if ("incremental".equals(string)) {
                    AbstractPatternPanel.this.getAction("matchIncremental").setSelected((Boolean)propertyChangeEvent.getNewValue());
                } else if ("empty".equals(string)) {
                    AbstractPatternPanel.this.refreshEmptyFromModel();
                }
            }
        };
        return propertyChangeListener;
    }

    protected void refreshEmptyFromModel() {
        boolean bl = !this.getPatternModel().isEmpty();
        this.getAction(MATCH_ACTION_COMMAND).setEnabled(bl);
    }

    protected void refreshModelFromDocument() {
        this.getPatternModel().setRawText(this.searchField.getText());
    }

    protected void refreshDocumentFromModel() {
        if (this.searchField.getText().equals(this.getPatternModel().getRawText())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractPatternPanel.this.searchField.setText(AbstractPatternPanel.this.getPatternModel().getRawText());
            }
        });
    }

    protected DocumentListener getSearchFieldListener() {
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }
        };
        return documentListener;
    }

    protected void bind() {
        this.bindSearchLabel();
        this.searchField.getDocument().addDocumentListener(this.getSearchFieldListener());
        this.getActionContainerFactory().configureButton(this.matchCheck, (AbstractActionExt)this.getActionMap().get("matchCase"), null);
    }

    protected void bindSearchLabel() {
        this.searchLabel.setText(this.getUIString(SEARCH_FIELD_LABEL));
        String string = this.getUIString(SEARCH_FIELD_MNEMONIC);
        if (string != SEARCH_FIELD_MNEMONIC) {
            this.searchLabel.setDisplayedMnemonic(string.charAt(0));
        }
        this.searchLabel.setLabelFor(this.searchField);
    }

    protected ActionContainerFactory getActionContainerFactory() {
        if (this.actionFactory == null) {
            this.actionFactory = new ActionContainerFactory(null);
        }
        return this.actionFactory;
    }

    protected void initComponents() {
        this.searchLabel = new JLabel();
        this.searchField = new JTextField(this.getSearchFieldWidth()){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        this.matchCheck = new JCheckBox();
    }

    protected int getSearchFieldWidth() {
        return 15;
    }

    static {
        LookAndFeelAddons.getAddon();
    }
}

