/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinglabs.build.ant;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class ReleaseNotesGenerator {
    private ReleaseNotesGenerator() {
    }

    private static void appendProject(String projectName, PrintWriter out) throws Exception {
        out.print("<h2>Project: ");
        out.print(projectName);
        out.println("</h2>");
        FileInputStream is = new FileInputStream("c:/cygwin/usr/local/src/point8release/swinglabs/build-files/changelogs/" + projectName + "-description.xml");
        ReleaseNotesGenerator.appendNotes(is, out);
        is = new FileInputStream("c:/cygwin/usr/local/src/point8release/swinglabs/build-files/changelogs/" + projectName + "-changelog.xml");
        ReleaseNotesGenerator.appendIssues(is, out);
        ((InputStream)is).close();
    }

    private static void appendNotes(InputStream description, PrintWriter out) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        DescriptionHandler handler = new DescriptionHandler();
        parser.parse(description, (DefaultHandler)handler);
        out.println(handler.descriptionHtml);
        for (Feature f : handler.features) {
            out.print("<h5>");
            out.print(f.title);
            out.println("</h5>");
            out.println(f.descriptionHtml);
        }
    }

    private static void appendIssues(InputStream changelog, PrintWriter out) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        ChangelogHandler handler = new ChangelogHandler();
        parser.parse(changelog, (DefaultHandler)handler);
        out.println("<p>");
        out.println("<h5>Resolved Issues</h5>");
        out.println("<table width=\"100%\">");
        out.println("<tr>");
        out.println("<th colspan=\"6\">Thu Nov 17 21:57:53 +0000 2005</th>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<th>ID</th>");
        out.println("<th>Type</th>");
        out.println("<th>Priority</th>");
        out.println("<th>Votes</th>");
        out.println("<th>Component</th>");
        out.println("<th>Summary</th>");
        out.println("</tr>");
        Collections.sort(handler.issues, new Comparator<Issue>(){

            @Override
            public int compare(Issue one, Issue two) {
                return one.priority.compareTo(two.priority);
            }
        });
        boolean evenRow = false;
        for (Issue issue : handler.issues) {
            if (!issue.fixed) continue;
            String url = handler.urlbase + "show_bug.cgi?id=" + issue.id;
            out.print("<tr class=\"");
            out.print(evenRow ? "even" : "odd");
            out.println("\">");
            evenRow = !evenRow;
            out.print("<td>");
            out.print("<a href=\"");
            out.print(url);
            out.print("\">");
            out.print(issue.id);
            out.print("</a>");
            out.println("</td>");
            String color = "BLACK";
            if (issue.type.equals("TASK")) {
                color = "BLACK";
            } else if (issue.type.equals("DEFECT")) {
                color = "RED";
            } else if (issue.type.equals("PATCH")) {
                color = "GREEN";
            } else if (issue.type.equals("FEATUR")) {
                color = "BLUE";
            } else if (issue.type.equals("ENHANC")) {
                color = "PURPLE";
            }
            out.print("<td><font color=\"");
            out.print(color);
            out.print("\"><span class=\"issue_type\">");
            out.print(issue.type);
            out.println("</span></font></td>");
            out.print("<td><font color=\"");
            out.print(color);
            out.print("\"><span class=\"priority\">");
            out.print(issue.priority);
            out.println("</span></font></td>");
            out.print("<td><font color=\"");
            out.print(color);
            out.print("\"><span class=\"votes\">");
            out.print(issue.votes);
            out.println("</span></font></td>");
            out.print("<td><font color=\"");
            out.print(color);
            out.print("\"><span class=\"component\">");
            out.print(issue.component);
            out.println("</span></font></td>");
            out.print("<td><font color=\"");
            out.print(color);
            out.print("\"><span class=\"summary\">");
            out.print(issue.description);
            out.println("</span></font></td>");
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</p>");
    }

    public static void main(String ... args) {
        try {
            PrintWriter out = new PrintWriter("c:/cygwin/usr/local/src/point8release/swinglabs/build-files/ReleaseNotes.html");
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            out.println("<html>");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("<title>SwingLabs Release Notes</title>");
            out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"swinglabs.css\" />");
            out.println("</head>");
            out.println("<body>");
            out.println("<div id=\"container\">");
            out.println("<div id=\"stitch-hack\">");
            out.println("<div id=\"banner\">");
            out.println("</div>");
            out.println("<div id=\"menu\">");
            out.println("<img class=\"menu-left\" src=\"images/menu-left.png\" alt=\"\" /><a href=\"README.html\">Readme</a><img class=\"menu-right\" src=\"images/menu-right.png\" alt=\"\" />");
            out.println("<img class=\"menu-left\" src=\"images/menu-left.png\" alt=\"\" /><a href=\"ReleaseNotes.html\">Release Notes</a><img class=\"menu-right\" src=\"images/menu-right.png\" alt=\"\" />");
            out.println("<img class=\"menu-left\" src=\"images/menu-left.png\" alt=\"\" /><a href=\"docs/api/index.html\">JavaDoc</a><img class=\"menu-right\" src=\"images/menu-right.png\" alt=\"\" />");
            out.println("<img class=\"menu-left\" src=\"images/menu-left.png\" alt=\"\" /><a href=\"http://swinglabs.org/\">Main Website</a><img class=\"menu-right\" src=\"images/menu-right.png\" alt=\"\" />");
            out.println("</div>");
            out.println("<div id=\"content\">");
            out.println("<div id=\"section\">");
            out.println("<p><h2><center>Release Notes</center></h2>");
            out.println("<h4 align=\"right\">Release Date: 17 November 2005<br/>");
            out.println("This is the 0.8 development release</h4></p>");
            ReleaseNotesGenerator.appendProject("swingx", out);
            ReleaseNotesGenerator.appendProject("databinding", out);
            out.println("</div>");
            out.println("</div>");
            out.println("<div id=\"footer\">");
            out.println("</div>");
            out.println("</div>");
            out.println("</div>");
            out.println("</body>");
            out.println("</html>");
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static final class Feature {
        private String title;
        private String descriptionHtml;

        private Feature() {
        }
    }

    private static final class Issue {
        private String id;
        private String priority;
        private boolean fixed;
        private String component;
        private String type;
        private int votes;
        private String description;

        private Issue() {
        }
    }

    private static final class ChangelogHandler
    extends DefaultHandler2 {
        private String urlbase;
        private String projectName;
        private Issue issue;
        private List<Issue> issues = new ArrayList<Issue>();
        private int depth = -1;
        private StringBuilder buffer;

        private ChangelogHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String chars = this.buffer.toString();
            if (this.depth == 2) {
                if (qName.equalsIgnoreCase("priority")) {
                    this.issue.priority = chars;
                } else if (qName.equalsIgnoreCase("resolution")) {
                    this.issue.fixed = chars.equalsIgnoreCase("FIXED");
                } else if (qName.equalsIgnoreCase("component")) {
                    this.issue.component = chars;
                } else if (qName.equalsIgnoreCase("issue_type")) {
                    this.issue.type = chars;
                } else if (qName.equalsIgnoreCase("votes")) {
                    this.issue.votes = 0;
                    try {
                        this.issue.votes = Integer.parseInt(chars);
                    }
                    catch (Exception e) {}
                } else if (qName.equalsIgnoreCase("short_desc")) {
                    this.issue.description = chars;
                } else if (qName.equalsIgnoreCase("issue_id")) {
                    this.issue.id = chars;
                }
            } else if (this.depth == 1) {
                this.issues.add(this.issue);
            }
            --this.depth;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.depth;
            if (this.depth == 0) {
                this.urlbase = attributes.getValue("urlbase");
                this.projectName = attributes.getValue("project_name");
            } else if (this.depth == 1) {
                this.issue = new Issue();
            }
            this.buffer = new StringBuilder(0);
        }
    }

    private static final class DescriptionHandler
    extends DefaultHandler2 {
        private String descriptionHtml;
        private Feature feature;
        private List<Feature> features = new ArrayList<Feature>();
        private int depth = -1;
        private StringBuilder buffer;

        private DescriptionHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String chars = this.buffer.toString();
            if (this.depth == 2) {
                if (qName.equalsIgnoreCase("title")) {
                    this.feature.title = chars;
                } else if (qName.equalsIgnoreCase("description")) {
                    this.feature.descriptionHtml = chars;
                }
            } else if (this.depth == 1) {
                if (qName.equalsIgnoreCase("description")) {
                    this.descriptionHtml = chars;
                } else if (qName.equalsIgnoreCase("feature")) {
                    this.features.add(this.feature);
                }
            }
            --this.depth;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.depth;
            if (this.depth == 1 && qName.equalsIgnoreCase("feature")) {
                this.feature = new Feature();
            }
            this.buffer = new StringBuilder(0);
        }
    }
}

