/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.io.schema;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetIOUtility {
    private static final Logger LOG = Logger.getLogger(DataSetIOUtility.class.getName());

    private DataSetIOUtility() {
    }

    public static Class getType(int n) {
        switch (n) {
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                return Object.class;
            }
            case -7: 
            case -2: 
            case 16: {
                return Boolean.class;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case -4: 
            case -3: 
            case 2004: {
                return byte[].class;
            }
            case 1: {
                return Character.class;
            }
            case 2005: {
                return char[].class;
            }
            case 91: 
            case 92: 
            case 93: {
                return Date.class;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return BigDecimal.class;
            }
            case -1: 
            case 12: {
                return String.class;
            }
        }
        LOG.warning("Unsupported JDBC type; type is unknown, so mapping to Object.class. Type value was " + n);
        return Object.class;
    }

    public static Map<String, Set<String>> extractTableList(String ... stringArray) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>(5);
        for (String string : stringArray) {
            int n = string.indexOf(".");
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (!hashMap.containsKey(string2)) {
                    hashMap.put(string2, new HashSet());
                }
                if (hashMap.get(string2) == null) continue;
                ((Set)hashMap.get(string2)).add(string3);
                continue;
            }
            hashMap.put(string, null);
        }
        return hashMap;
    }

    public static String getDefaultSchemaName(DatabaseMetaData databaseMetaData) {
        String string = null;
        try {
            ResultSet resultSet = databaseMetaData.getSchemas();
            boolean bl = false;
            while (resultSet.next() && !bl) {
                bl = resultSet.getBoolean("IS_DEFAULT");
                if (!bl) continue;
                string = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public static List<String> extractColumn(ResultSet resultSet, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static void dumpCatalogDetails(DatabaseMetaData databaseMetaData, PrintWriter printWriter) {
        try {
            printWriter.println(databaseMetaData.getCatalogTerm());
            ResultSet resultSet = databaseMetaData.getCatalogs();
            while (resultSet.next()) {
                int n = resultSet.getMetaData().getColumnCount();
                while (--n >= 0) {
                    printWriter.println("Col: " + resultSet.getMetaData().getColumnName(n));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static PrintWriter getPrintWriter(Writer writer) {
        if (writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        return new PrintWriter(new BufferedWriter(writer));
    }
}

