/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jga.fn.EvaluationException;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.adaptor.Constant;
import net.sf.jga.parser.ParseException;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataSetUtils;
import org.jdesktop.dataset.NameGenerator;
import org.jdesktop.dataset.Parser;

public class DataValue {
    protected static final String DEFAULT_NAME_PREFIX = "DataValue";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataValue");
    private static final Logger LOG = Logger.getLogger(DataValue.class.getName());
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataSet dataSet;
    private String name;
    private String expression;
    private Generator<?> exprImpl;

    public DataValue(DataSet dataSet) {
        assert (dataSet != null);
        this.dataSet = dataSet;
        this.name = NAMEGEN.generateName(this);
    }

    public DataValue(DataSet dataSet, String string) {
        this(dataSet);
        if (string != null) {
            this.setName(string);
        }
    }

    public void setName(String string) {
        if (this.name != string) {
            assert (DataSetUtils.isValidName(string));
            String string2 = this.name;
            this.name = string;
            this.pcs.firePropertyChange("name", string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.expression)) {
            String string2 = this.expression;
            this.expression = string;
            this.pcs.firePropertyChange("expression", string2, string);
        }
    }

    public Object getValue() {
        if (this.exprImpl == null) {
            if (this.expression == null || this.expression.equals("")) {
                this.exprImpl = new Constant(null);
            } else {
                try {
                    this.exprImpl = this.getParser().parseDataValue(this.expression);
                }
                catch (ParseException parseException) {
                    LOG.log(Level.WARNING, "The expression {0} is not valid. {1}", new Object[]{this.expression, parseException});
                    assert (false) : "The expression is not valid. See log for details";
                    this.exprImpl = null;
                }
            }
        }
        try {
            return this.exprImpl == null ? null : this.exprImpl.gen();
        }
        catch (EvaluationException evaluationException) {
            LOG.log(Level.WARNING, "Failed to compute and return value", evaluationException);
            return null;
        }
    }

    Parser getParser() {
        return this.dataSet.getParser();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }
}

