/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataSetUtils;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.NameGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRelation {
    private static final Logger LOG = Logger.getLogger(DataRelation.class.getName());
    protected static final String DEFAULT_NAME_PREFIX = "DataRelation";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataRelation");
    private DataSet dataSet;
    private String name;
    private DataColumn parentColumn;
    private DataColumn childColumn;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected DataRelation(DataSet dataSet) {
        assert (dataSet != null);
        this.dataSet = dataSet;
        this.name = NAMEGEN.generateName(this);
    }

    protected DataRelation(DataSet dataSet, String string) {
        this(dataSet);
        if (string != null) {
            this.setName(string);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setName(String string) {
        if (this.name != string) {
            assert (DataSetUtils.isValidName(string));
            assert (!this.dataSet.hasElement(string));
            String string2 = this.name;
            this.name = string;
            this.pcs.firePropertyChange("name", string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public DataColumn getParentColumn() {
        return this.parentColumn;
    }

    public void setParentColumn(DataColumn dataColumn) {
        if (this.parentColumn != dataColumn) {
            assert (dataColumn != this.childColumn);
            DataColumn dataColumn2 = this.parentColumn;
            this.parentColumn = dataColumn;
            this.pcs.firePropertyChange("parentColumn", dataColumn2, dataColumn);
        }
    }

    public DataColumn getChildColumn() {
        return this.childColumn;
    }

    public void setChildColumn(DataColumn dataColumn) {
        if (this.childColumn != dataColumn) {
            assert (dataColumn != this.parentColumn);
            DataColumn dataColumn2 = this.childColumn;
            this.childColumn = dataColumn;
            this.pcs.firePropertyChange("childColumn", dataColumn2, dataColumn);
        }
    }

    public List<DataRow> getRows(DataRow dataRow) {
        if (this.parentColumn == null || this.childColumn == null || dataRow == null) {
            return Collections.unmodifiableList(Collections.EMPTY_LIST);
        }
        assert (dataRow.getTable().equals(this.parentColumn.getTable()));
        DataTable dataTable = this.childColumn.getTable();
        Object object = this.parentColumn.getTable().getValue(dataRow, this.parentColumn);
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (DataRow dataRow2 : dataTable.getRows()) {
            Object object2 = dataTable.getValue(dataRow2, this.childColumn);
            if (object == null || object2 == null || !object.equals(object2)) continue;
            arrayList.add(dataRow2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<DataRow> getRows(int n) {
        if (this.parentColumn == null || this.childColumn == null || n < 0) {
            return Collections.unmodifiableList(Collections.EMPTY_LIST);
        }
        DataTable dataTable = this.parentColumn.getTable();
        return this.getRows(dataTable.getRow(n));
    }

    public List<DataRow> getRows(DataRow[] dataRowArray) {
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (DataRow dataRow : dataRowArray) {
            arrayList.addAll(this.getRows(dataRow));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<DataRow> getRows(int[] nArray) {
        if (this.parentColumn == null || this.childColumn == null || nArray == null) {
            return Collections.unmodifiableList(Collections.EMPTY_LIST);
        }
        DataTable dataTable = this.parentColumn.getTable();
        DataRow[] dataRowArray = new DataRow[nArray.length];
        for (int i = 0; i < dataRowArray.length; ++i) {
            dataRowArray[i] = dataTable.getRow(nArray[i]);
        }
        return this.getRows(dataRowArray);
    }

    public List<DataRow> getRows(List<Integer> list) {
        if (this.parentColumn == null || this.childColumn == null || list == null) {
            return Collections.unmodifiableList(Collections.EMPTY_LIST);
        }
        DataTable dataTable = this.parentColumn.getTable();
        DataRow[] dataRowArray = new DataRow[list.size()];
        for (int i = 0; i < dataRowArray.length; ++i) {
            dataRowArray[i] = dataTable.getRow(list.get(i));
        }
        return this.getRows(dataRowArray);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }
}

