/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jdesktop.dataset.DataCommand;
import org.jdesktop.dataset.DataConnection;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.provider.LoadTask;
import org.jdesktop.dataset.provider.SaveTask;
import org.jdesktop.dataset.provider.Task;

public abstract class DataProvider {
    private static final Executor EX = Executors.newCachedThreadPool();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataCommand command;
    private DataConnection connection;

    public void load(DataTable[] dataTableArray) {
        LoadTask loadTask = this.createLoadTask(dataTableArray);
        this.runTask(loadTask);
    }

    public void loadAndWait(DataTable[] dataTableArray) {
        LoadTask loadTask = this.createLoadTask(dataTableArray);
        loadTask.setLoadOnEDT(false);
        this.runTaskAndWait(loadTask);
    }

    public void load(DataTable dataTable) {
        this.load(new DataTable[]{dataTable});
    }

    public void loadAndWait(DataTable dataTable) {
        this.loadAndWait(new DataTable[]{dataTable});
    }

    public void save(DataTable dataTable) {
        this.save(new DataTable[]{dataTable});
    }

    public void saveAndWait(DataTable dataTable) {
        this.saveAndWait(new DataTable[]{dataTable});
    }

    public void save(DataTable[] dataTableArray) {
        SaveTask saveTask = this.createSaveTask(dataTableArray);
        this.runTask(saveTask);
    }

    public void saveAndWait(DataTable[] dataTableArray) {
        SaveTask saveTask = this.createSaveTask(dataTableArray);
        this.runTaskAndWait(saveTask);
    }

    protected abstract SaveTask createSaveTask(DataTable[] var1);

    protected abstract LoadTask createLoadTask(DataTable[] var1);

    protected void runTask(Task task) {
        EX.execute(task);
    }

    protected void runTaskAndWait(Task task) {
        task.run();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void setCommand(DataCommand dataCommand) {
        if (this.command != dataCommand) {
            DataCommand dataCommand2 = this.command;
            this.command = dataCommand;
            this.pcs.firePropertyChange("command", dataCommand2, dataCommand);
        }
    }

    public DataCommand getCommand() {
        return this.command;
    }

    public void setConnection(DataConnection dataConnection) {
        if (this.connection != dataConnection) {
            DataConnection dataConnection2 = this.connection;
            this.connection = dataConnection;
            this.pcs.firePropertyChange("connection", dataConnection2, dataConnection);
        }
    }

    public DataConnection getConnection() {
        return this.connection;
    }
}

