/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx.adapter;

import org.jdesktop.binding.metadata.Converter;
import org.jdesktop.binding.swingx.adapter.HierarchicalDataMetaData;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAdapter
extends DefaultTreeTableModel {
    protected Document dom = null;
    private HierarchicalDataMetaData metaData;

    public DOMAdapter() {
    }

    public DOMAdapter(Document document) {
        this.bind(document);
    }

    public final void bind(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("null document object model");
        }
        if (this.dom != null) {
            throw new IllegalArgumentException("dom already bound");
        }
        this.dom = document;
        Element element = (Element)document.getDocumentElement().getElementsByTagNameNS("http://www.jdesktop.org/2004/05/jdnc", "metaData").item(0);
        this.setMetaData(new HierarchicalDataMetaData(element));
    }

    public String convertValueToText(Object object) {
        Object object2;
        if (object != null && (object2 = this.getValueAt(object, 0)) != null) {
            return object2.toString();
        }
        return "";
    }

    public Object getRoot() {
        return this.dom.getDocumentElement().getElementsByTagNameNS("http://www.jdesktop.org/2004/05/jdnc", "rows").item(0);
    }

    public Class getColumnClass(int n) {
        return n == 0 ? super.getColumnClass(0) : this.getMetaData().getColumnClass(n + 1);
    }

    public Object getChild(Object object, int n) {
        Element element = (Element)object;
        NodeList nodeList = element.getChildNodes();
        int n2 = 0;
        int n3 = n;
        int n4 = nodeList.getLength();
        while (n2 < n4) {
            Element element2;
            Node node;
            if (!((node = nodeList.item(n2++)) instanceof Element) || !(element2 = (Element)node).getLocalName().equals("row") || n3-- != 0) continue;
            return element2;
        }
        return null;
    }

    public int getChildCount(Object object) {
        Element element = (Element)object;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = 0;
        int n3 = nodeList.getLength();
        Element element2 = null;
        while (n < n3) {
            Node node;
            if (!((node = nodeList.item(n++)) instanceof Element) || !(element2 = (Element)node).getLocalName().equals("row")) continue;
            ++n2;
        }
        return n2;
    }

    public void setMetaData(HierarchicalDataMetaData hierarchicalDataMetaData) {
        this.metaData = hierarchicalDataMetaData;
    }

    public HierarchicalDataMetaData getMetaData() {
        return this.metaData;
    }

    public int getColumnCount() {
        return this.getMetaData().getColumnCount();
    }

    public int getColumnIndex(String string) {
        return this.getMetaData().getColumnIndex(string);
    }

    public String getColumnName(int n) {
        return this.getMetaData().getColumnName(n + 1);
    }

    public Object getValueAt(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("Node is null; " + n);
        }
        Element element = (Element)object;
        NodeList nodeList = element.getChildNodes();
        int n2 = 0;
        int n3 = n;
        int n4 = nodeList.getLength();
        while (n2 < n4) {
            Element element2;
            Node node;
            if (!((node = nodeList.item(n2++)) instanceof Element) || !(element2 = (Element)node).getLocalName().equals("cell") || n3-- != 0) continue;
            Node node2 = element2.getFirstChild();
            String string = node2 == null ? "" : node2.getNodeValue();
            Converter converter = this.getMetaData().getColumnConverter(n + 1);
            if (converter == null) {
                return string;
            }
            try {
                return converter.decode(string, null);
            }
            catch (Exception exception) {
                return string;
            }
        }
        return null;
    }
}

