/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.InitialGradientCalculator;
import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MinimumSeed;
import org.freehep.math.minuit.MinimumSeedGenerator;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.VariableMetricEDMEstimator;

class SimplexSeedGenerator
implements MinimumSeedGenerator {
    SimplexSeedGenerator() {
    }

    public MinimumSeed generate(MnFcn fcn, GradientCalculator gc2, MnUserParameterState st, MnStrategy stra) {
        int n = st.variableParameters();
        MnMachinePrecision prec = st.precision();
        MnAlgebraicVector x = new MnAlgebraicVector(n);
        for (int i = 0; i < n; ++i) {
            x.set(i, (Double)st.intParameters().get(i));
        }
        double fcnmin = fcn.valueOf(x);
        MinimumParameters pa = new MinimumParameters(x, fcnmin);
        InitialGradientCalculator igc = new InitialGradientCalculator(fcn, st.trafo(), stra);
        FunctionGradient dgrad = igc.gradient(pa);
        MnAlgebraicSymMatrix mat = new MnAlgebraicSymMatrix(n);
        double dcovar = 1.0;
        for (int i = 0; i < n; ++i) {
            mat.set(i, i, Math.abs(dgrad.g2().get(i)) > prec.eps2() ? 1.0 / dgrad.g2().get(i) : 1.0);
        }
        MinimumError err = new MinimumError(mat, dcovar);
        double edm = new VariableMetricEDMEstimator().estimate(dgrad, err);
        MinimumState state = new MinimumState(pa, err, dgrad, edm, fcn.numOfCalls());
        return new MinimumSeed(state, st.trafo());
    }
}

