/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

public class MnStrategy {
    private int theStrategy;
    private int theGradNCyc;
    private double theGradTlrStp;
    private double theGradTlr;
    private int theHessNCyc;
    private double theHessTlrStp;
    private double theHessTlrG2;
    private int theHessGradNCyc;

    public MnStrategy() {
        this.setMediumStrategy();
    }

    public MnStrategy(int stra) {
        if (stra == 0) {
            this.setLowStrategy();
        } else if (stra == 1) {
            this.setMediumStrategy();
        } else {
            this.setHighStrategy();
        }
    }

    public int strategy() {
        return this.theStrategy;
    }

    public int gradientNCycles() {
        return this.theGradNCyc;
    }

    public double gradientStepTolerance() {
        return this.theGradTlrStp;
    }

    public double gradientTolerance() {
        return this.theGradTlr;
    }

    public int hessianNCycles() {
        return this.theHessNCyc;
    }

    public double hessianStepTolerance() {
        return this.theHessTlrStp;
    }

    public double hessianG2Tolerance() {
        return this.theHessTlrG2;
    }

    public int hessianGradientNCycles() {
        return this.theHessGradNCyc;
    }

    public boolean isLow() {
        return this.theStrategy <= 0;
    }

    public boolean isMedium() {
        return this.theStrategy == 1;
    }

    public boolean isHigh() {
        return this.theStrategy >= 2;
    }

    public void setLowStrategy() {
        this.theStrategy = 0;
        this.setGradientNCycles(2);
        this.setGradientStepTolerance(0.5);
        this.setGradientTolerance(0.1);
        this.setHessianNCycles(3);
        this.setHessianStepTolerance(0.5);
        this.setHessianG2Tolerance(0.1);
        this.setHessianGradientNCycles(1);
    }

    public void setMediumStrategy() {
        this.theStrategy = 1;
        this.setGradientNCycles(3);
        this.setGradientStepTolerance(0.3);
        this.setGradientTolerance(0.05);
        this.setHessianNCycles(5);
        this.setHessianStepTolerance(0.3);
        this.setHessianG2Tolerance(0.05);
        this.setHessianGradientNCycles(2);
    }

    void setHighStrategy() {
        this.theStrategy = 2;
        this.setGradientNCycles(5);
        this.setGradientStepTolerance(0.1);
        this.setGradientTolerance(0.02);
        this.setHessianNCycles(7);
        this.setHessianStepTolerance(0.1);
        this.setHessianG2Tolerance(0.02);
        this.setHessianGradientNCycles(6);
    }

    public void setGradientNCycles(int n) {
        this.theGradNCyc = n;
    }

    public void setGradientStepTolerance(double stp) {
        this.theGradTlrStp = stp;
    }

    public void setGradientTolerance(double toler) {
        this.theGradTlr = toler;
    }

    public void setHessianNCycles(int n) {
        this.theHessNCyc = n;
    }

    public void setHessianStepTolerance(double stp) {
        this.theHessTlrStp = stp;
    }

    public void setHessianG2Tolerance(double toler) {
        this.theHessTlrG2 = toler;
    }

    public void setHessianGradientNCycles(int n) {
        this.theHessGradNCyc = n;
    }
}

