/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.MinosError;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnApplication;
import org.freehep.math.minuit.MnCross;
import org.freehep.math.minuit.MnFunctionCross;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.Point;

public class MnMinos {
    private FCNBase theFCN;
    private FunctionMinimum theMinimum;
    private MnStrategy theStrategy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MnMinos(FCNBase fcn, FunctionMinimum min) {
        this(fcn, min, MnApplication.DEFAULT_STRATEGY);
    }

    public MnMinos(FCNBase fcn, FunctionMinimum min, int stra) {
        this(fcn, min, new MnStrategy(stra));
    }

    public MnMinos(FCNBase fcn, FunctionMinimum min, MnStrategy stra) {
        this.theFCN = fcn;
        this.theMinimum = min;
        this.theStrategy = stra;
    }

    public MinosError minos(int par) {
        return this.minos(par, 1.0);
    }

    public MinosError minos(int par, double errDef) {
        return this.minos(par, errDef, MnApplication.DEFAULT_MAXFCN);
    }

    public MinosError minos(int par, double errDef, int maxcalls) {
        if (!$assertionsDisabled && !this.theMinimum.isValid()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.theMinimum.userState().parameter(par).isFixed()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.theMinimum.userState().parameter(par).isConst()) {
            throw new AssertionError();
        }
        MnCross up = this.upval(par, errDef, maxcalls);
        MnCross lo = this.loval(par, errDef, maxcalls);
        return new MinosError(par, this.theMinimum.userState().value(par), lo, up);
    }

    public Point range(int par) {
        return this.range(par, 1.0);
    }

    public Point range(int par, double errDef) {
        return this.range(par, errDef, MnApplication.DEFAULT_MAXFCN);
    }

    public Point range(int par, double errDef, int maxcalls) {
        MinosError mnerr = this.minos(par, errDef, maxcalls);
        return mnerr.range();
    }

    public double lower(int par) {
        return this.lower(par, 1.0);
    }

    public double lower(int par, double errDef) {
        return this.lower(par, errDef, MnApplication.DEFAULT_MAXFCN);
    }

    public double lower(int par, double errDef, int maxcalls) {
        MnUserParameterState upar = this.theMinimum.userState();
        double err = this.theMinimum.userState().error(par);
        MnCross aopt = this.loval(par, errDef, maxcalls);
        double lower = aopt.isValid() ? -1.0 * err * (1.0 + aopt.value()) : (aopt.atLimit() ? upar.parameter(par).lowerLimit() : upar.value(par));
        return lower;
    }

    public double upper(int par) {
        return this.upper(par, 1.0);
    }

    public double upper(int par, double errDef) {
        return this.upper(par, errDef, MnApplication.DEFAULT_MAXFCN);
    }

    public double upper(int par, double errDef, int maxcalls) {
        MnUserParameterState upar = this.theMinimum.userState();
        double err = this.theMinimum.userState().error(par);
        MnCross aopt = this.upval(par, errDef, maxcalls);
        double upper = aopt.isValid() ? err * (1.0 + aopt.value()) : (aopt.atLimit() ? upar.parameter(par).upperLimit() : upar.value(par));
        return upper;
    }

    public MnCross loval(int par) {
        return this.loval(par, 1.0);
    }

    public MnCross loval(int par, double errDef) {
        return this.loval(par, errDef, MnApplication.DEFAULT_MAXFCN);
    }

    public MnCross loval(int par, double errDef, int maxcalls) {
        errDef *= this.theMinimum.errorDef();
        if (!$assertionsDisabled && !this.theMinimum.isValid()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.theMinimum.userState().parameter(par).isFixed()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.theMinimum.userState().parameter(par).isConst()) {
            throw new AssertionError();
        }
        if (maxcalls == 0) {
            int nvar = this.theMinimum.userState().variableParameters();
            maxcalls = 2 * (nvar + 1) * (200 + 100 * nvar + 5 * nvar * nvar);
        }
        int[] para = new int[]{par};
        MnUserParameterState upar = (MnUserParameterState)this.theMinimum.userState().clone();
        double err = upar.error(par);
        double val = upar.value(par) - err;
        double[] xmid = new double[]{val};
        double[] xdir = new double[]{-err};
        int ind = upar.intOfExt(par);
        MnAlgebraicSymMatrix m = this.theMinimum.error().matrix();
        double xunit = Math.sqrt(errDef / err);
        for (int i = 0; i < m.nrow(); ++i) {
            if (i == ind) continue;
            double xdev = xunit * m.get(ind, i);
            int ext = upar.extOfInt(i);
            upar.setValue(ext, upar.value(ext) - xdev);
        }
        upar.fix(par);
        upar.setValue(par, val);
        double toler = 0.1;
        MnFunctionCross cross = new MnFunctionCross(this.theFCN, upar, this.theMinimum.fval(), this.theStrategy, errDef);
        MnCross aopt = cross.cross(para, xmid, xdir, toler, maxcalls);
        if (aopt.atLimit()) {
            System.out.println("MnMinos parameter " + par + " is at lower limit.");
        }
        if (aopt.atMaxFcn()) {
            System.out.println("MnMinos maximum number of function calls exceeded for parameter " + par);
        }
        if (aopt.newMinimum()) {
            System.out.println("MnMinos new minimum found while looking for parameter " + par);
        }
        if (!aopt.isValid()) {
            System.out.println("MnMinos could not find lower value for parameter " + par + ".");
        }
        return aopt;
    }

    public MnCross upval(int par) {
        return this.upval(par, 1.0);
    }

    public MnCross upval(int par, double errDef) {
        return this.upval(par, errDef, MnApplication.DEFAULT_MAXFCN);
    }

    public MnCross upval(int par, double errDef, int maxcalls) {
        errDef *= this.theMinimum.errorDef();
        if (!$assertionsDisabled && !this.theMinimum.isValid()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.theMinimum.userState().parameter(par).isFixed()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.theMinimum.userState().parameter(par).isConst()) {
            throw new AssertionError();
        }
        if (maxcalls == 0) {
            int nvar = this.theMinimum.userState().variableParameters();
            maxcalls = 2 * (nvar + 1) * (200 + 100 * nvar + 5 * nvar * nvar);
        }
        int[] para = new int[]{par};
        MnUserParameterState upar = (MnUserParameterState)this.theMinimum.userState().clone();
        double err = upar.error(par);
        double val = upar.value(par) + err;
        double[] xmid = new double[]{val};
        double[] xdir = new double[]{err};
        int ind = upar.intOfExt(par);
        MnAlgebraicSymMatrix m = this.theMinimum.error().matrix();
        double xunit = Math.sqrt(errDef / err);
        for (int i = 0; i < m.nrow(); ++i) {
            if (i == ind) continue;
            double xdev = xunit * m.get(ind, i);
            int ext = upar.extOfInt(i);
            upar.setValue(ext, upar.value(ext) + xdev);
        }
        upar.fix(par);
        upar.setValue(par, val);
        double toler = 0.1;
        MnFunctionCross cross = new MnFunctionCross(this.theFCN, upar, this.theMinimum.fval(), this.theStrategy, errDef);
        MnCross aopt = cross.cross(para, xmid, xdir, toler, maxcalls);
        if (aopt.atLimit()) {
            System.err.println("MnMinos parameter " + par + " is at upper limit.");
        }
        if (aopt.atMaxFcn()) {
            System.err.println("MnMinos maximum number of function calls exceeded for parameter " + par);
        }
        if (aopt.newMinimum()) {
            System.err.println("MnMinos new minimum found while looking for parameter " + par);
        }
        if (!aopt.isValid()) {
            System.err.println("MnMinos could not find upper value for parameter " + par + ".");
        }
        return aopt;
    }

    static {
        $assertionsDisabled = !MnMinos.class.desiredAssertionStatus();
    }
}

