/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolyPolyline;

public class PolyPolyline16
extends AbstractPolyPolyline {
    private int numberOfPolys;

    public PolyPolyline16() {
        super(90, 1, null, null, null);
    }

    public PolyPolyline16(Rectangle bounds, int numberOfPolys, int[] numberOfPoints, Point[][] points) {
        super(90, 1, bounds, numberOfPoints, points);
        this.numberOfPolys = numberOfPolys;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int i;
        Rectangle bounds = emf.readRECTL();
        int np = emf.readDWORD();
        emf.readDWORD();
        int[] pc = new int[np];
        Point[][] points = new Point[np][];
        for (i = 0; i < np; ++i) {
            pc[i] = emf.readDWORD();
            points[i] = new Point[pc[i]];
        }
        for (i = 0; i < np; ++i) {
            points[i] = emf.readPOINTS(pc[i]);
        }
        return new PolyPolyline16(bounds, np, pc, points);
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        int i;
        int[] numberOfPoints = this.getNumberOfPoints();
        Point[][] points = this.getPoints();
        emf.writeRECTL(this.getBounds());
        emf.writeDWORD(this.numberOfPolys);
        int c = 0;
        for (i = 0; i < this.numberOfPolys; ++i) {
            c += numberOfPoints[i];
        }
        emf.writeDWORD(c);
        for (i = 0; i < this.numberOfPolys; ++i) {
            emf.writeDWORD(numberOfPoints[i]);
        }
        for (i = 0; i < this.numberOfPolys; ++i) {
            emf.writePOINTS(numberOfPoints[i], points[i]);
        }
    }
}

