/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.Color;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.freehep.application.Application;

public abstract class PropertyUtilities {
    public static Rectangle getRectangle(Properties prop, String key, Rectangle def) {
        try {
            Rectangle result = new Rectangle();
            result.x = PropertyUtilities.getInteger(prop, key.concat("-x"));
            result.y = PropertyUtilities.getInteger(prop, key.concat("-y"));
            result.width = PropertyUtilities.getInteger(prop, key.concat("-w"));
            result.height = PropertyUtilities.getInteger(prop, key.concat("-h"));
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static void setRectangle(Properties prop, String key, Rectangle rect) {
        prop.put(key.concat("-x"), String.valueOf(rect.x));
        prop.put(key.concat("-y"), String.valueOf(rect.y));
        prop.put(key.concat("-w"), String.valueOf(rect.width));
        prop.put(key.concat("-h"), String.valueOf(rect.height));
    }

    public static Color getColor(Properties prop, String key, Color def) {
        try {
            return new Color(PropertyUtilities.getInteger(prop, key.concat("-r")), PropertyUtilities.getInteger(prop, key.concat("-g")), PropertyUtilities.getInteger(prop, key.concat("-b")));
        }
        catch (Exception e) {
            return def;
        }
    }

    public static void setColor(Properties prop, String key, Color c) {
        prop.put(key.concat("-r"), String.valueOf(c.getRed()));
        prop.put(key.concat("-g"), String.valueOf(c.getGreen()));
        prop.put(key.concat("-b"), String.valueOf(c.getBlue()));
    }

    public static Collection getStringCollection(Properties prop, String key, Collection def) {
        try {
            int length = PropertyUtilities.getInteger(prop, key + "-length");
            ArrayList<String> result = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                String value = prop.getProperty(key + "-" + i);
                if (value == null) continue;
                result.add(value);
            }
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static void setStringCollection(Properties prop, String key, Collection sa) {
        try {
            int length = PropertyUtilities.getInteger(prop, key + "-length");
            for (int i = 0; i < length; ++i) {
                prop.remove(key + "-" + i);
            }
            prop.remove(key + "-length");
        }
        catch (Exception e) {
            // empty catch block
        }
        prop.put(key + "-length", sa == null ? "0" : String.valueOf(sa.size()));
        if (sa != null) {
            int k = 0;
            Iterator i = sa.iterator();
            while (i.hasNext()) {
                prop.put(key + "-" + k, (String)i.next());
                ++k;
            }
        }
    }

    public static String[] getStringArray(Properties prop, String key, String[] def) {
        try {
            String[] result = new String[PropertyUtilities.getInteger(prop, key + "-length")];
            for (int i = 0; i < result.length; ++i) {
                result[i] = prop.getProperty(key + "-" + i);
            }
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static void setStringArray(Properties prop, String key, String[] sa) {
        prop.put(key + "-length", sa == null ? "0" : String.valueOf(sa.length));
        if (sa != null) {
            for (int i = 0; i < sa.length; ++i) {
                prop.put(key + "-" + i, sa[i]);
            }
        }
    }

    public static String getString(Properties prop, String key, String def) {
        try {
            String s = prop.getProperty(key);
            return s == null ? def : s;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static void setString(Properties prop, String key, String s) {
        if (s == null) {
            s = "";
        }
        prop.put(key, s);
    }

    public static boolean getBoolean(Properties prop, String key, boolean def) {
        String value = prop.getProperty(key);
        return value == null ? def : value.equalsIgnoreCase("true");
    }

    public static void setBoolean(Properties prop, String key, boolean value) {
        prop.put(key, String.valueOf(value));
    }

    public static int getInteger(Properties prop, String key) throws NumberFormatException {
        return Integer.parseInt(prop.getProperty(key));
    }

    public static int getInteger(Properties prop, String key, int def) {
        try {
            String s = prop.getProperty(key);
            return s == null ? def : Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static void setInteger(Properties prop, String key, int i) {
        prop.put(key, String.valueOf(i));
    }

    public static void setFloat(Properties prop, String key, float f) {
        prop.put(key, String.valueOf(f));
    }

    public static float getFloat(Properties prop, String key, float def) {
        try {
            String s = prop.getProperty(key);
            return s == null ? def : Float.parseFloat(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static void setURL(Properties prop, String key, URL url) {
        prop.put(key, url.toString());
    }

    public static URL getURL(Properties prop, String key, URL def) {
        String p = prop.getProperty(key);
        if (p == null) {
            return def;
        }
        try {
            return new URL(p);
        }
        catch (MalformedURLException x) {
            URL url = Application.getApplication().getClass().getResource(p);
            return url == null ? def : url;
        }
    }

    public static String translate(Properties prop, String in) {
        int end;
        int start;
        if (in == null) {
            return null;
        }
        StringBuffer out = null;
        int l = in.length();
        int pos = 0;
        while (pos < l && (start = in.indexOf(123, pos)) >= 0 && (end = in.indexOf(125, start)) >= 0 && end - start >= 2) {
            if (out == null) {
                out = new StringBuffer(in.substring(0, start));
            } else {
                out.append(in.substring(pos, start));
            }
            String value = prop.getProperty(in.substring(start + 1, end));
            if (value != null) {
                out.append(value);
            }
            pos = end + 1;
        }
        if (out == null) {
            return in;
        }
        if (pos < l) {
            out.append(in.substring(pos));
        }
        return out.toString();
    }

    public static class TranslatedProperties
    extends Properties {
        public TranslatedProperties() {
        }

        public TranslatedProperties(Properties def) {
            super(def);
        }

        public String getProperty(String key) {
            return PropertyUtilities.translate(this, super.getProperty(key));
        }

        public String getProperty(String key, String def) {
            return PropertyUtilities.translate(this, super.getProperty(key, def));
        }
    }

    public static class PropertyTable
    extends AbstractTableModel
    implements Comparator {
        private List list;

        PropertyTable(Properties prop) {
            this.list = new ArrayList<Map.Entry<Object, Object>>(prop.entrySet());
            Collections.sort(this.list, this);
        }

        public int compare(Object o1, Object o2) {
            Map.Entry entry1 = (Map.Entry)o1;
            Map.Entry entry2 = (Map.Entry)o2;
            String name1 = entry1.getKey().toString();
            String name2 = entry2.getKey().toString();
            return name1.compareTo(name2);
        }

        public int getRowCount() {
            return this.list.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int row, int column) {
            Map.Entry entry = (Map.Entry)this.list.get(row);
            return column == 0 ? entry.getKey() : entry.getValue();
        }

        public String getColumnName(int col) {
            return col == 0 ? "Property" : "Value";
        }
    }
}

