/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.ComponentNodeTraverser;
import jas.hist.JASHist;
import jas.hist.XMLPrintWriter;
import jas.plot.Legend;
import jas.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class LegendNodeTraverser
extends ComponentNodeTraverser {
    private Node node;
    private Legend legend;
    private JASHist plot;

    LegendNodeTraverser() {
    }

    void traverse(Node node, Legend legend, JASHist plot) throws XMLNodeTraverser.BadXMLException {
        this.plot = plot;
        this.legend = legend;
        this.node = node;
    }

    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("legendEntry")) {
            int index = this.toInt(node.getAttribute("index"));
            this.legend.setCurrentTitle(index, node.getAttribute("title"));
        } else {
            super.handleElement(node, name);
        }
    }

    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("visible")) {
            this.plot.setShowLegend(this.toVisibility(value));
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    void applyLegendEntries() throws XMLNodeTraverser.BadXMLException {
        if (this.node != null) {
            super.traverse(this.node, this.legend);
        }
    }

    private int toVisibility(String value) throws XMLNodeTraverser.BadXMLException {
        return XMLPrintWriter.convertStringToLegend(value);
    }
}

