/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.BackgroundTransport;
import ice.util.I18N;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SimpleMailer {
    private static SimpleMailer reference = null;
    private static final String HOST_KEY = "ice.util.SimpleMailer.host";
    protected String host = null;

    private SimpleMailer() {
        this.init();
    }

    private void init() {
        this.host = I18N.getString(HOST_KEY);
        if (this.host == null) {
            this.host = "messaging.nist.gov";
        }
    }

    public static SimpleMailer getReference() {
        if (reference == null) {
            reference = new SimpleMailer();
        }
        return reference;
    }

    public void mail(String to, String from, String subject, String body) throws MessagingException {
        Properties props = null;
        Session session = null;
        MimeMessage msg = null;
        props = new Properties();
        props.put("mail.host", this.host);
        props.put("mail.debug", "false");
        session = Session.getInstance(props);
        msg = new MimeMessage(session);
        ((Message)msg).setFrom(new InternetAddress(from));
        Address[] address = new InternetAddress[]{new InternetAddress(to)};
        ((Message)msg).setRecipients(Message.RecipientType.TO, address);
        ((Message)msg).setSubject(subject);
        ((Message)msg).setSentDate(new Date());
        msg.setText(body);
        new BackgroundTransport(msg).start();
    }
}

