/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.I18N;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.DefaultFormatter;

public class RegexPatternFormatter
extends DefaultFormatter {
    protected static final String MISSING_FORMATTER_KEY = "ice.util.RegexPatternFormatter.errorMessage.missingFormatter";
    protected static final String PARSE_ERROR_KEY = "ice.util.RegexPatternFormatter.errorMessage.parseError";
    protected Matcher matcher = null;

    public RegexPatternFormatter() {
        this.init(null);
    }

    public RegexPatternFormatter(Pattern regex) {
        this.init(regex);
    }

    protected void init(Pattern regex) {
        this.setOverwriteMode(false);
        this.setPattern(regex);
    }

    public void setPattern(Pattern regex) {
        this.matcher = regex != null ? regex.matcher("") : null;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        Object returnValue = null;
        String errorString = null;
        if (this.matcher == null) {
            errorString = I18N.getString(MISSING_FORMATTER_KEY);
            throw new ParseException(errorString, 0);
        }
        if (string != null) {
            this.matcher.reset(string);
            if (!this.matcher.matches()) {
                errorString = I18N.getString(PARSE_ERROR_KEY);
                errorString = MessageFormat.format(errorString, string);
                throw new ParseException(errorString, 0);
            }
            returnValue = super.stringToValue(string);
        }
        return returnValue;
    }
}

