/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.ConfigClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class I18N {
    private static Logger logger = Logger.getLogger(I18N.class);
    public static final String UNDEFINED = "undefined";
    private static ResourceBundle rb = ResourceBundle.getBundle("stringConstants", Locale.getDefault(), new ConfigClassLoader());

    public static String getString(String key) {
        String stringConstant = UNDEFINED;
        try {
            stringConstant = rb.getString(key);
        }
        catch (NullPointerException npe) {
            logger.error("Key is null.  Aborting.", npe);
        }
        catch (MissingResourceException mre) {
            logger.error("No resource exists for key.  Aborting.", mre);
        }
        catch (ClassCastException cce) {
            logger.error("Resource is not a string.  Aborting.", cce);
        }
        return stringConstant;
    }
}

