/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.textFields;

import ice.event.MinMaxResetEvent;
import ice.event.NumberOutOfRangeListener;
import ice.event.TextChangedThroughSetText;
import ice.swing.textFields.ChangeBackgroundOnEditFormattedTextField;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;

public class ICELongFormattedTextField
extends ChangeBackgroundOnEditFormattedTextField
implements FocusListener {
    protected DecimalFormat decimalFormat = null;
    private static final String STARTER_FORMAT_STRING = "#######";
    protected boolean allowsNegitives = true;
    protected long minValue;
    protected long maxValue;
    protected String oldText;
    protected ArrayList<NumberOutOfRangeListener> numberOutOfRangeListeners;
    protected boolean allowEmptyText;
    protected int lostFocusBehavior;
    protected NumberOutOfRangeListener.NumberRange state;

    public ICELongFormattedTextField() {
        this(true);
    }

    public ICELongFormattedTextField(boolean allowsNegetive) {
        this(DecimalFormat.getInstance());
        this.init(allowsNegetive);
    }

    private ICELongFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
    }

    private ICELongFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
    }

    private ICELongFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
    }

    private ICELongFormattedTextField(Object value) {
        super(value);
    }

    protected ICELongFormattedTextField(Format format) {
        super(format);
        this.decimalFormat = (DecimalFormat)format;
    }

    protected void init(boolean allowsNegitives) {
        NumberFormatter nf = null;
        NumberOutOfRangeListener.NumberRange state = NumberOutOfRangeListener.NumberRange.NOT_A_NUMBER;
        this.addFocusListener(this);
        this.numberOutOfRangeListeners = new ArrayList();
        this.allowEmptyText = false;
        this.allowsNegitives = allowsNegitives;
        this.lostFocusBehavior = this.getFocusLostBehavior();
        this.setMinValue(Long.MIN_VALUE);
        this.setMaxValue(Long.MAX_VALUE);
        this.oldText = this.getText();
        nf = (NumberFormatter)this.getFormatter();
        nf.setAllowsInvalid(true);
        nf.setOverwriteMode(false);
        this.decimalFormat.setMaximumFractionDigits(0);
        this.decimalFormat.applyPattern(STARTER_FORMAT_STRING);
    }

    public void allowEmptyText(boolean allow) {
        this.allowEmptyText = allow;
        if (this.allowEmptyText) {
            this.lostFocusBehavior = this.getFocusLostBehavior();
            this.setFocusLostBehavior(3);
        } else {
            this.setFocusLostBehavior(this.lostFocusBehavior);
        }
    }

    public int getNumberOfFractionDigits() {
        return this.decimalFormat.getMaximumFractionDigits();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = this.allowsNegitives ? minValue : 0L;
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(new MinMaxResetEvent(this));
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(new MinMaxResetEvent(this));
    }

    public double getLong() {
        long theValue = 0L;
        theValue = ((Number)this.getValue()).longValue();
        return theValue;
    }

    @Override
    public void setText(String text) {
        this.oldText = this.getText();
        if (this.allowEmptyText && (text == null || text.trim().equals(""))) {
            super.setText("");
            return;
        }
        if (text == null || text.trim().equals("")) {
            text = "0";
        }
        if (this.decimalFormat != null) {
            Double tempDouble = 0.0;
            long tempLong = 0L;
            try {
                tempDouble = Double.valueOf(text);
                tempLong = tempDouble.longValue();
                text = this.decimalFormat.format(tempLong);
            }
            catch (NumberFormatException e) {
                Toolkit.getDefaultToolkit().beep();
                text = this.oldText;
            }
        }
        super.setText(text);
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(new TextChangedThroughSetText(this));
    }

    public void setValue(long theValue) {
        Long theLong = null;
        this.oldText = this.getText();
        theLong = theValue;
        this.setValue(theLong);
    }

    public NumberOutOfRangeListener.NumberRange inRange() {
        NumberOutOfRangeListener.NumberRange returnValue = NumberOutOfRangeListener.NumberRange.IN_RANGE;
        String text = this.getText();
        returnValue = this.inRange(text);
        return returnValue;
    }

    public void addNumberOutOfRangeListener(NumberOutOfRangeListener l) {
        this.numberOutOfRangeListeners.add(l);
    }

    public void removeNumberOutOfRangeListener(NumberOutOfRangeListener l) {
        this.numberOutOfRangeListeners.remove(l);
    }

    protected NumberOutOfRangeListener.NumberRange inRange(String text) {
        NumberOutOfRangeListener.NumberRange returnValue;
        block6: {
            returnValue = NumberOutOfRangeListener.NumberRange.IN_RANGE;
            try {
                try {
                    Long value = Long.parseLong(text);
                    if (value < this.minValue || value > this.maxValue) {
                        returnValue = NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE;
                    }
                }
                catch (NumberFormatException e) {
                    returnValue = NumberOutOfRangeListener.NumberRange.NOT_A_NUMBER;
                    Color foreGround = returnValue == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE ? Color.red : Color.black;
                    this.setForeground(foreGround);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Color foreGround = returnValue == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE ? Color.red : Color.black;
                this.setForeground(foreGround);
                throw throwable;
            }
            Color foreGround = returnValue == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE ? Color.red : Color.black;
            this.setForeground(foreGround);
        }
        return returnValue;
    }

    protected void notifyNumberOutOfRangeListenersIfTextOutOfRange(ComponentEvent componentEvent) {
        NumberOutOfRangeListener.NumberRange inRange = NumberOutOfRangeListener.NumberRange.NOT_A_NUMBER;
        inRange = this.inRange();
        if (inRange != this.state || componentEvent instanceof FocusEvent) {
            this.state = inRange;
            String text = this.getText();
            String min = Long.toString(this.minValue);
            String max = Long.toString(this.maxValue);
            NumberOutOfRangeListener.NumberOutOfRangeEvent numberOutOfRangeEvent = new NumberOutOfRangeListener.NumberOutOfRangeEvent(this.oldText, text, inRange, min, max, componentEvent, this);
            if (this.numberOutOfRangeListeners != null) {
                for (NumberOutOfRangeListener l : this.numberOutOfRangeListeners) {
                    l.handleOutOfRangeNumber(numberOutOfRangeEvent);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        super.keyReleased(evt);
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(evt);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(e);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        Object source = null;
        source = evt.getSource();
        if (source == this) {
            char theChar = '\u0000';
            int charetPosition = -1;
            String text = null;
            int posOfPeriod = -1;
            int posOfNegitive = -1;
            boolean actLikeNothingHappened = false;
            theChar = evt.getKeyChar();
            charetPosition = ((JFormattedTextField)source).getCaretPosition();
            text = this.getText();
            posOfPeriod = text.indexOf(46);
            posOfNegitive = text.indexOf(45);
            switch (theChar) {
                case '-': {
                    if (charetPosition == 0 && this.allowsNegitives) break;
                    actLikeNothingHappened = true;
                    break;
                }
                case '\b': {
                    break;
                }
                default: {
                    boolean isDigit = false;
                    isDigit = Character.isDigit(theChar);
                    if (isDigit) break;
                    actLikeNothingHappened = true;
                }
            }
            if (actLikeNothingHappened) {
                Toolkit.getDefaultToolkit().beep();
                evt.consume();
            } else {
                this.oldText = this.getText();
                super.keyTyped(evt);
            }
        }
    }

    public void clear() {
        if (this.allowEmptyText) {
            this.setText("");
            this.setBackgroundToNormalColor();
        } else {
            this.setValue(0L);
        }
    }
}

