/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.buttons;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;

public class ImageButton
extends AbstractButton
implements MouseMotionListener,
MouseListener {
    protected ImageIcon activeImage;
    protected ImageIcon normalImage;
    protected ImageIcon pressedImage;
    protected ImageIcon rolloverImage;
    protected Shape shape;
    boolean mouseIsDown = false;

    public ImageButton(ImageIcon normalImage, ImageIcon pressedImage, ImageIcon rolloverImage) {
        this.setModel(new DefaultButtonModel());
        this.normalImage = normalImage;
        this.pressedImage = pressedImage;
        this.rolloverImage = rolloverImage;
        this.activeImage = this.normalImage;
        this.shape = new Ellipse2D.Double(0.0, 0.0, this.normalImage.getIconWidth(), this.normalImage.getIconHeight());
        this.setPreferredSize(new Dimension(this.normalImage.getIconWidth(), this.normalImage.getIconHeight()));
        this.setMaximumSize(new Dimension(this.normalImage.getIconWidth(), this.normalImage.getIconHeight()));
        this.setMinimumSize(new Dimension(this.normalImage.getIconWidth(), this.normalImage.getIconHeight()));
        this.setOpaque(false);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public ImageButton(ImageIcon image, ImageIcon pressedImage) {
        this(image, pressedImage, null);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.activeImage != null) {
            this.activeImage.paintIcon(this, g2d, 0, 0);
        }
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.normalImage.getIconWidth(), this.normalImage.getIconHeight());
    }

    @Override
    public Dimension getSize(Dimension rv) {
        rv.width = this.normalImage.getIconWidth();
        rv.height = this.normalImage.getIconHeight();
        return rv;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        Point point = me.getPoint();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.activeImage = this.mouseIsDown ? this.pressedImage : this.rolloverImage;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.activeImage = this.mouseIsDown ? this.rolloverImage : this.normalImage;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Point point = me.getPoint();
        if (this.shape.contains(point)) {
            this.activeImage = this.pressedImage;
            this.repaint();
        }
        this.mouseIsDown = true;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        Point point = me.getPoint();
        if (this.shape.contains(point)) {
            ActionEvent ae = new ActionEvent(this, 1001, this.getText(), me.getWhen(), me.getModifiers());
            this.fireActionPerformed(ae);
            this.activeImage = this.rolloverImage;
        } else {
            this.activeImage = this.normalImage;
        }
        this.mouseIsDown = false;
        this.repaint();
    }
}

