/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class RememberDecisionDialog
extends JDialog
implements ItemListener {
    DialogType type;
    EnumSet<Decision> status;

    private RememberDecisionDialog(JFrame parent, String title, String body, DialogType type, boolean remember, Icon icon) {
        super((Frame)parent, true);
        Insets dialogInsets = new Insets(10, 10, 10, 10);
        this.type = type;
        JCheckBox checkBox = new JCheckBox("Remember my decision");
        checkBox.addItemListener(this);
        if (remember) {
            this.status = EnumSet.of(Decision.Remember);
            checkBox.setSelected(true);
        } else {
            this.status = EnumSet.noneOf(Decision.class);
            checkBox.setSelected(false);
        }
        GridBagConstraints checkBoxConstraints = new GridBagConstraints();
        checkBoxConstraints.gridx = 0;
        checkBoxConstraints.gridy = 2;
        checkBoxConstraints.gridwidth = 2;
        checkBoxConstraints.gridheight = 2;
        checkBoxConstraints.insets = dialogInsets;
        JLabel bodyLabel = body == null ? new JLabel("") : new JLabel(body);
        GridBagConstraints bodyLabelConstraints = new GridBagConstraints();
        bodyLabelConstraints.gridx = 1;
        bodyLabelConstraints.gridy = 0;
        bodyLabelConstraints.gridwidth = 5;
        bodyLabelConstraints.gridheight = 1;
        bodyLabelConstraints.insets = dialogInsets;
        if (icon == null) {
            icon = (Icon)UIManager.get("OptionPane.questionIcon");
        }
        JLabel iconLabel = new JLabel(icon);
        GridBagConstraints iconLabelConstraints = new GridBagConstraints();
        iconLabelConstraints.gridx = 0;
        iconLabelConstraints.gridy = 0;
        iconLabelConstraints.gridwidth = 1;
        iconLabelConstraints.gridheight = 1;
        iconLabelConstraints.insets = dialogInsets;
        JPanel buttonPanel = new JPanel();
        GridBagConstraints buttonPanelConstraints = new GridBagConstraints();
        buttonPanelConstraints.gridx = 2;
        buttonPanelConstraints.gridy = 4;
        buttonPanelConstraints.gridwidth = 16;
        buttonPanelConstraints.gridheight = 1;
        buttonPanelConstraints.insets = dialogInsets;
        switch (type) {
            case OKCancel: {
                DialogButtonAction OKAction2 = new DialogButtonAction(this, "OK", Decision.OK);
                DialogButtonAction cancelAction = new DialogButtonAction(this, "Cancel", Decision.Cancel);
                JButton OKBtn = new JButton(OKAction2);
                JButton cancelBtn = new JButton(cancelAction);
                buttonPanel.add(OKBtn);
                buttonPanel.add(cancelBtn);
                break;
            }
            case YesNo: {
                DialogButtonAction yesAction = new DialogButtonAction(this, "Yes", Decision.Yes);
                DialogButtonAction noAction = new DialogButtonAction(this, "No", Decision.No);
                JButton yesBtn = new JButton(yesAction);
                JButton noBtn = new JButton(noAction);
                buttonPanel.add(yesBtn);
                buttonPanel.add(noBtn);
                break;
            }
            case YesNoCancel: {
                DialogButtonAction yesAction = new DialogButtonAction(this, "Yes", Decision.Yes);
                DialogButtonAction noAction = new DialogButtonAction(this, "No", Decision.No);
                DialogButtonAction cancelAction = new DialogButtonAction(this, "Cancel", Decision.Cancel);
                JButton yesBtn = new JButton(yesAction);
                JButton noBtn = new JButton(noAction);
                JButton cancelBtn = new JButton(cancelAction);
                buttonPanel.add(yesBtn);
                buttonPanel.add(noBtn);
                buttonPanel.add(cancelBtn);
            }
        }
        this.setTitle(title);
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.setLayout(new GridBagLayout());
        this.add((Component)bodyLabel, bodyLabelConstraints);
        this.add((Component)iconLabel, iconLabelConstraints);
        this.add((Component)buttonPanel, buttonPanelConstraints);
        this.add((Component)checkBox, checkBoxConstraints);
        this.pack();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.type == DialogType.OKCancel || this.type == DialogType.YesNoCancel) {
                this.status.add(Decision.Cancel);
                this.dispose();
                super.processWindowEvent(e);
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    EnumSet<Decision> getStatus() {
        return this.status;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            this.status.remove((Object)Decision.Remember);
        } else if (e.getStateChange() == 1) {
            this.status.add(Decision.Remember);
        }
    }

    public static EnumSet<Decision> showDialog(JFrame parent, String title, String body, DialogType type, boolean remember, Icon icon) {
        RememberDecisionDialog dialog = new RememberDecisionDialog(parent, title, body, type, remember, icon);
        dialog.setVisible(true);
        return dialog.getStatus();
    }

    public static EnumSet<Decision> showDialog(JFrame parent, String title, String body, DialogType type, boolean remember, IconType iconType) {
        Icon icon = null;
        switch (iconType) {
            case Question: {
                icon = (Icon)UIManager.get("OptionPane.questionIcon");
                break;
            }
            case Info: {
                icon = (Icon)UIManager.get("OptionPane.infoIcon");
                break;
            }
            case Warning: {
                icon = (Icon)UIManager.get("OptionPane.warningIcon");
                break;
            }
            case Error: {
                icon = (Icon)UIManager.get("OptionPane.errorIcon");
            }
        }
        return RememberDecisionDialog.showDialog(parent, title, body, type, remember, icon);
    }

    public static EnumSet<Decision> showDialog(JFrame parent, String title, String body, DialogType type, boolean remember) {
        return RememberDecisionDialog.showDialog(parent, title, body, type, remember, null);
    }

    public static EnumSet<Decision> showDialog(JFrame parent, String title, String body, DialogType type) {
        return RememberDecisionDialog.showDialog(parent, title, body, type, false, null);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Icon icon = (Icon)UIManager.get("OptionPane.questionIcon");
                EnumSet<Decision> result = RememberDecisionDialog.showDialog(null, "TEST DIALOG", "<HTML>Do you want to really do this?<BR>  It will cause motors to move!</HTML>", DialogType.YesNoCancel);
                if (result.contains((Object)Decision.OK)) {
                    System.out.println("OK");
                }
                if (result.contains((Object)Decision.Cancel)) {
                    System.out.println("Cancel");
                }
                if (result.contains((Object)Decision.Yes)) {
                    System.out.println("Yes");
                }
                if (result.contains((Object)Decision.No)) {
                    System.out.println("No");
                }
                if (result.contains((Object)Decision.Remember)) {
                    System.out.println("Remember");
                }
                if (!result.contains((Object)Decision.Remember)) {
                    System.out.println("NoRemember");
                }
            }
        });
    }

    public static enum Decision {
        OK,
        Yes,
        No,
        Cancel,
        Remember;

    }

    protected class DialogButtonAction
    extends AbstractAction {
        private Decision decision;
        private JDialog dialog;

        public DialogButtonAction(JDialog dialog, String name, Decision decision) {
            this.dialog = dialog;
            this.putValue("Name", name);
            this.decision = decision;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            RememberDecisionDialog.this.status.add(this.decision);
            this.dialog.dispose();
        }
    }

    public static enum DialogType {
        OKCancel,
        YesNo,
        YesNoCancel;

    }

    public static enum IconType {
        Question,
        Info,
        Warning,
        Error;

    }
}

