/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.FileClassLoader;
import ice.Global;
import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.swing.DeviceLabel;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class DeviceValueLabel
extends DeviceLabel {
    private static DecimalFormat df;
    private Color defaultBGColor = this.getBackground();

    static {
        ResourceBundle rb = ResourceBundle.getBundle("preferences", Locale.getDefault(), new FileClassLoader());
        double decimalLength = Double.parseDouble(rb.getString("device.label.decimalLength"));
        String format = "0.";
        int i = 0;
        while ((double)i < decimalLength) {
            format = String.valueOf(format) + "0";
            ++i;
        }
        if (format.endsWith(".")) {
            format = format.substring(0, format.length() - 1);
        }
        df = new DecimalFormat(format);
    }

    public DeviceValueLabel(InstalledDevice device) {
        super(device, 20);
        this.updateLabel();
    }

    private void updateLabel() {
        if (this.device == null) {
            String currValue = "N/A";
            SwingUtilities.invokeLater((DeviceLabel)this.new DeviceLabel.UpdateLabel(currValue, Color.BLACK));
        } else {
            String units;
            String currValue = this.device.getCurrValue();
            try {
                double tempValue = Double.parseDouble(currValue);
                currValue = df.format(tempValue);
            }
            catch (NumberFormatException tempValue) {
                // empty catch block
            }
            if (currValue.charAt(0) != '-') {
                currValue = "  " + currValue;
            }
            if ((units = this.device.getUnits()).equalsIgnoreCase("deg") || units.equalsIgnoreCase("degrees")) {
                units = Global.degreeSign();
            } else if (units.equalsIgnoreCase("None")) {
                units = "";
            }
            SwingUtilities.invokeLater((DeviceLabel)this.new DeviceLabel.UpdateLabel(String.valueOf(currValue) + units, Color.BLACK));
        }
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent pce) {
        if (pce.getSource() != this.device) {
            return;
        }
        this.updateLabel();
    }
}

