/*
 * Decompiled with CFR 0.152.
 */
package ice.rubberband;

import ice.rubberband.RubberBand;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class XlibRubberBand
extends RubberBand {
    private static final String RESOURCE_DIR = "src/ice/rubberband/";
    private static final String RESOURCE_NAME = "rubberbandlib";
    private static final String RESOURCE_EXTENSION = ".so";
    private static final String RESOURCE_FILE = "librubberbandlib.so";
    private Rectangle currentRect1;
    private Rectangle currentRect2;

    static {
        XlibRubberBand.loadLibrary();
    }

    private native void drawRectangle(int var1, int var2, int var3, int var4);

    private native void clearRectangle(int var1, int var2, int var3, int var4);

    private native void cleanup();

    public static void loadLibrary() {
        System.out.println(System.getProperty("user.dir"));
        ClassLoader cl = XlibRubberBand.class.getClassLoader();
        InputStream in = cl.getResourceAsStream(RESOURCE_FILE);
        if (in != null) {
            File file = new File(String.valueOf(System.getProperty("user.home")) + "/.jice");
            file.mkdirs();
            file = new File(String.valueOf(file.getAbsolutePath()) + "/" + RESOURCE_NAME + RESOURCE_EXTENSION);
            FileOutputStream fileOut = null;
            try {
                try {
                    fileOut = new FileOutputStream(file);
                    byte[] tmp = new byte[1024];
                    int bytesRead = in.read(tmp);
                    while (bytesRead != -1) {
                        fileOut.write(tmp, 0, bytesRead);
                        bytesRead = in.read(tmp);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println("Unable to find file.  THIS SHOULDN'T HAPPEN (since I created the file).");
                    XlibRubberBand.close(in);
                    XlibRubberBand.close(fileOut);
                    return;
                }
                catch (IOException ioe) {
                    System.out.println("Unable to write to file");
                    XlibRubberBand.close(in);
                    XlibRubberBand.close(fileOut);
                    return;
                }
            }
            finally {
                XlibRubberBand.close(in);
                XlibRubberBand.close(fileOut);
            }
            System.load(file.getAbsolutePath());
        } else {
            System.out.println("Unable to locate resource file (librubberbandlib.so) in class path.");
        }
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("Unable to close input stream.");
        }
    }

    public static void close(OutputStream os2) {
        try {
            if (os2 != null) {
                os2.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("Unable to close output stream.");
        }
    }

    @Override
    public void paint(Graphics g, Rectangle r) {
        this.clear();
        this.currentRect1 = r;
        this.draw(this.currentRect1, true);
    }

    @Override
    public void clear() {
        this.draw(this.currentRect1, false);
        this.currentRect1 = null;
    }

    private void draw(Rectangle r, boolean xor) {
        if (r == null) {
            return;
        }
        if (xor) {
            this.drawRectangle(r.x, r.y, r.width, r.height);
        } else {
            this.clearRectangle(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void paint(Graphics g, Rectangle r1, Rectangle r2) {
        this.clearBoth();
        this.currentRect1 = r1;
        this.currentRect2 = r2;
        this.draw(this.currentRect1, true);
        this.draw(this.currentRect2, true);
    }

    public void clearBoth() {
        this.draw(this.currentRect1, false);
        this.draw(this.currentRect2, false);
        this.currentRect1 = null;
        this.currentRect2 = null;
    }
}

