/*
 * Decompiled with CFR 0.152.
 */
package ice.jython.management;

import com.artenum.jyconsole.python.JInteractiveInterpreter;
import com.artenum.util.PropertyLoader;
import ice.Controller;
import ice.Global;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.FileGetCommand;
import ice.communication.CommunicationManager;
import ice.data.IceFile;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.BroadcastMessageEvent;
import ice.event.communication.BroadcastMessageListener;
import ice.event.communication.PythonResetEvent;
import ice.event.communication.PythonResetListener;
import ice.jython.console.JythonConsole;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyStringMap;

public class PythonContainer
implements BroadcastMessageListener {
    private static PythonContainer reference = null;
    private static final String path = Global.getConfigPath();
    private static final String separator = Global.separator;
    public static final String PYTHON_FILE_EXTENSION = ".py";
    private static final String pythonDirectory = String.valueOf(path) + separator + "Plugins" + separator + "Python";
    static final String PROPERTIES_FILE = String.valueOf(path) + separator + "jyconsole.properties";
    public static final String USER_ICE_CONFIG_TAG = "<UserICEConfig>/";
    private JythonConsole jyConsole = null;
    private ICEListenerList<PythonResetListener, PythonResetEvent> resetListeners = null;

    protected PythonContainer() {
        this.init();
    }

    public static PythonContainer getReference() {
        if (reference == null) {
            reference = new PythonContainer();
        }
        return reference;
    }

    protected void init() {
        Controller controller = Controller.getReference();
        CommunicationManager commManager = controller.getCommMgr();
        try {
            commManager.addMessageListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("Could not add listener " + e);
        }
        this.resetListeners = new ICEListenerList();
        this.createInterpreter();
    }

    @Override
    public void actionPerformed(BroadcastMessageEvent me) {
        String data = me.getData();
        if (data.startsWith("Kill received:")) {
            this.stop();
        }
    }

    protected void createInterpreter() {
        this.loadJythonProperties();
        this.jyConsole = JythonConsole.newInstance();
        this.loadAndExecutePythonFilesInPythonDir();
    }

    public void reset() {
        PythonResetEvent pythonResetEvent = new PythonResetEvent(this);
        this.jyConsole.killJyConsoleDead();
        this.createInterpreter();
        this.resetListeners.notifyListeners(pythonResetEvent);
    }

    public void stop() {
        this.jyConsole.stopInterpreter();
    }

    public void addPythonResetListener(PythonResetListener l) throws ICEListenerListExceptionBase {
        this.resetListeners.addListener(l);
    }

    public void removePythonResetListener(PythonResetListener l) {
        this.resetListeners.removeListener(l);
    }

    protected void replaceUserConfigTagWithUsersConfigDir(String property) {
        String aProperty = System.getProperty(property);
        if (aProperty.startsWith(USER_ICE_CONFIG_TAG)) {
            String userConfigPath = Global.getConfigPath();
            aProperty = String.valueOf(userConfigPath) + aProperty.replaceFirst(USER_ICE_CONFIG_TAG, "");
            aProperty = aProperty.replace('/', Global.separator.charAt(0));
            System.setProperty(property, aProperty);
        }
    }

    protected void loadJythonProperties() {
        try {
            PropertyLoader.loadProperties(PROPERTIES_FILE);
            this.replaceUserConfigTagWithUsersConfigDir("jyconsole.pref.loading.script");
            this.replaceUserConfigTagWithUsersConfigDir("jyconsole.pref.script.dir");
            this.replaceUserConfigTagWithUsersConfigDir("python.cachedir");
            this.replaceUserConfigTagWithUsersConfigDir("python.path");
        }
        catch (IOException e) {
            Logger.getLogger("ErrorLogger").error(e);
        }
    }

    public boolean loadRemotePythonFile(IceFile pythonFile) {
        boolean returnValue = false;
        String pythonCode = null;
        FileGetCommand fileGetCommand = null;
        String parentName = null;
        String fileName = null;
        IceFile parent = null;
        parent = pythonFile.getParent();
        parentName = parent == null ? "EXPT" : parent.getName();
        fileName = pythonFile.getName();
        try {
            fileGetCommand = new FileGetCommand(parentName, fileName);
            fileGetCommand.run();
            pythonCode = fileGetCommand.getResult();
            returnValue = fileGetCommand.isSuccess();
            if (returnValue) {
                this.execute(pythonCode);
            }
        }
        catch (NoClientAPIInstanceException e) {
            returnValue = false;
        }
        catch (ICEListenerListExceptionBase e) {
            returnValue = false;
        }
        return returnValue;
    }

    public JythonConsole getPythonConsole() {
        return this.jyConsole;
    }

    public void executeFile(File file) throws FileNotFoundException {
        try {
            FileInputStream fileInputStream = null;
            JInteractiveInterpreter pythonInterpreter = this.jyConsole.getPythonInterpreter();
            fileInputStream = new FileInputStream(file);
            pythonInterpreter.execfile(fileInputStream);
        }
        catch (Exception e) {
            this.jyConsole.writeToConsole(e.toString());
        }
    }

    public void execute(String pythonCode) {
        try {
            JInteractiveInterpreter pythonInterpreter = this.jyConsole.getPythonInterpreter();
            pythonInterpreter.exec(pythonCode);
        }
        catch (PyException e) {
            this.jyConsole.writeToConsole(e.toString());
        }
    }

    public boolean runsource(String pythonCode) {
        boolean returnValue = false;
        JInteractiveInterpreter pythonInterpreter = this.jyConsole.getPythonInterpreter();
        returnValue = pythonInterpreter.runsource(pythonCode);
        return returnValue;
    }

    public PyObject eval(String pythonCode) {
        PyObject returnValue = null;
        JInteractiveInterpreter pythonInterpreter = this.jyConsole.getPythonInterpreter();
        returnValue = pythonInterpreter.eval(pythonCode);
        return returnValue;
    }

    public PyStringMap getLocals() {
        PyStringMap listOfLocals = null;
        JInteractiveInterpreter pythonInterpreter = this.jyConsole.getPythonInterpreter();
        listOfLocals = (PyStringMap)pythonInterpreter.getLocals();
        return listOfLocals;
    }

    protected void loadAndExecutePythonFilesInPythonDir(File aDirectory) {
        boolean fileExists = false;
        fileExists = aDirectory.exists();
        if (fileExists) {
            boolean isADirectory = false;
            isADirectory = aDirectory.isDirectory();
            if (isADirectory) {
                File[] fileList = null;
                PythonFileFilter pythonFileFilter = null;
                pythonFileFilter = new PythonFileFilter();
                File[] fileArray = fileList = aDirectory.listFiles(pythonFileFilter);
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File aFile = fileArray[n2];
                    try {
                        isADirectory = aFile.isDirectory();
                        if (isADirectory) {
                            this.loadAndExecutePythonFilesInPythonDir(aFile);
                        } else {
                            this.executeFile(aFile);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }
    }

    protected void loadAndExecutePythonFileDownASpecificPath(String filePath) {
        String[] pathParts = null;
        String pythonDirectory = null;
        PythonFileFilterNoDirectories fileFilter = null;
        pythonDirectory = PythonContainer.pythonDirectory;
        File file = null;
        boolean dirExists = false;
        File[] filesToLoad = null;
        fileFilter = new PythonFileFilterNoDirectories();
        String[] stringArray = pathParts = filePath.split("\\.");
        int n = pathParts.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            pythonDirectory = String.valueOf(pythonDirectory) + separator + dir;
            file = new File(pythonDirectory);
            dirExists = file.mkdirs();
            File[] fileArray = filesToLoad = file.listFiles(fileFilter);
            int n3 = filesToLoad.length;
            int n4 = 0;
            while (n4 < n3) {
                File aFile = fileArray[n4];
                try {
                    this.executeFile(aFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void loadAndExecutePythonFilesInPythonDir() {
        Controller controller = null;
        Instrument instrument = null;
        String instrumentPath = null;
        controller = Controller.getReference();
        instrument = controller.getInstrument();
        instrumentPath = instrument.getPath();
        instrumentPath = instrumentPath.toLowerCase();
        this.loadAndExecutePythonFileDownASpecificPath(instrumentPath);
        this.execute("from ice import Controller");
        this.execute("from ice import Global");
        this.execute("from ice.ClientAPI import *");
        this.execute("from ice import IceGuiManager");
        this.execute("from ice.commands import *");
        this.execute("from ice.data import *");
        this.execute("from ice.communication import *");
        this.execute("from ice.event import *");
        this.execute("from ice.primitive import *");
        this.execute("from ice.util import *");
        this.execute("from java.awt import *");
        this.execute("from javax.swing import *");
        this.execute("from ice.gui.core import GenericIcePanel");
        this.execute("from ice.gui.core import IceViewPanel");
        this.execute("from ice.gui.core import IceDialog");
        this.execute("from ice.gui.core import IceEditPanel");
        this.execute("from ice.gui.core import IceWindow");
        this.execute("from ice.swing import *");
    }

    protected class PythonFileFilter
    implements FileFilter {
        protected PythonFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            boolean acceptFile = false;
            String fileName = null;
            boolean isDirectory = false;
            fileName = pathname.getName();
            isDirectory = pathname.isDirectory();
            if (isDirectory || fileName.endsWith(PythonContainer.PYTHON_FILE_EXTENSION)) {
                acceptFile = true;
            }
            return acceptFile;
        }
    }

    protected class PythonFileFilterNoDirectories
    implements FileFilter {
        protected PythonFileFilterNoDirectories() {
        }

        @Override
        public boolean accept(File pathname) {
            boolean acceptFile = false;
            String fileName = null;
            boolean isDirectory = false;
            fileName = pathname.getName();
            isDirectory = pathname.isDirectory();
            if (fileName.endsWith(PythonContainer.PYTHON_FILE_EXTENSION)) {
                acceptFile = true;
            }
            return acceptFile;
        }
    }
}

