/*
 * Decompiled with CFR 0.152.
 */
package ice.jython.console;

import com.artenum.jyconsole.command.Command;
import com.artenum.jyconsole.command.CommandRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.python.core.PyException;

public class KillableSingleThreadCommandRunner
implements CommandRunner,
Runnable {
    protected List runnables = new ArrayList();
    protected Thread currentThread;
    protected String threadName;
    protected Boolean stop;
    protected HashMap<Thread, Boolean> desiredThreadStatus;

    public KillableSingleThreadCommandRunner(String threadName) {
        this.threadName = threadName;
        this.desiredThreadStatus = new HashMap();
        this.stop = new Boolean(Boolean.FALSE);
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Boolean bl = this.stop;
        synchronized (bl) {
            this.currentThread = null;
            List list = this.runnables;
            synchronized (list) {
                try {
                    this.runnables.notify();
                }
                catch (Exception e) {
                    Logger.getLogger("ErrorLogger").error("Could not notify runnables object in KillableSingleThread " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeLater(Command r) {
        List list = this.runnables;
        synchronized (list) {
            this.runnables.add(r);
            if (this.runnables.size() > 0) {
                this.runnables.notify();
            }
        }
    }

    @Override
    public void reset() {
        this.stop();
        this.currentThread = new Thread((Runnable)this, this.threadName);
        this.currentThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (this.currentThread == Thread.currentThread()) {
            Command r = null;
            List list = this.runnables;
            synchronized (list) {
                while (true) {
                    if (this.runnables.size() != 0) {
                        if (this.currentThread == Thread.currentThread()) {
                            r = (Command)this.runnables.remove(0);
                        }
                        break;
                    }
                    try {
                        this.runnables.wait();
                        if (this.currentThread != null) continue;
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        continue;
                    }
                    break;
                }
            }
            try {
                if (r == null) continue;
                r.run();
            }
            catch (PyException t) {
                t.printStackTrace();
            }
        }
    }
}

