/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.tas.bt7;

import com.l2fprod.common.swing.JTaskPaneGroup;
import ice.Controller;
import ice.communication.CommunicationManager;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.DataMessageEvent;
import ice.event.communication.DataMessageListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.PlotPanel;
import ice.swing.Bag;
import ice.util.I18N;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import ptolemy.plot.Plot;

public class LiveDataPanel
extends PlotPanel
implements DataMessageListener,
ItemListener,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.LiveDataLogger");
    private final int NUMDIFFRACTIONDETECTORS = 3;
    private final int NUMSINGLEDETECTORS = 3;
    private final int NUMDOORDETECTORS = 11;
    private final int NUM_PSD_DETECTORS = 48;
    private Instrument instrument;
    private TreeMap<String, TreeMap<Integer, Double>> dataMap;
    private JComboBox xVarComboBox;
    private JComboBox yVarComboBox;
    private Plot plot;
    private Plot secondaryPlot;
    private JPanel statusBar;
    private JLabel currPointLabel;
    private JLabel totalPointsLabel;
    private JTaskPaneGroup secondaryPlotPanel;
    private JSlider slider;
    protected JLabel sliderLabel;
    private TreeMap<Integer, Double> xMap;
    private TreeMap<Integer, Double> yMap;
    private TreeMap<Integer, TreeMap<Integer, Double>> doorDetPoints;
    protected TreeMap<Integer, TreeMap<Integer, Double>> psDetPoints;
    private int currentSum = 1;
    protected int numScanPoints = 0;
    protected Hashtable<Integer, JLabel> sdLabelTable;
    protected Hashtable<Integer, JLabel> psdLabelTable;
    protected Instrument.DetectorMode lastScanDetectorMode;
    private Controller controller;

    public LiveDataPanel() throws IcePanelException {
        super("Live Data");
    }

    @Override
    protected void init() {
        this.controller = Controller.getReference();
        this.instrument = this.controller.getInstrument();
        this.lastScanDetectorMode = this.instrument.getDetectorMode();
        CommunicationManager comManager = this.controller.getCommMgr();
        try {
            comManager.addDataMessageListener(this);
        }
        catch (ICEListenerListExceptionBase e1) {
            logger.error("LiveDataPanel.init could not add listener " + e1);
        }
        this.dataMap = new TreeMap();
        this.dataMap.put("DATA", new TreeMap());
        this.plot = new Plot();
        this.plot.setMarksStyle("dots");
        this.plot.setXRange(0.0, 1.0);
        this.plot.setYRange(0.0, 1.0);
        this.secondaryPlot = new Plot();
        this.secondaryPlot.setMarksStyle("dots");
        this.secondaryPlot.setXRange(0.0, 1.0);
        this.secondaryPlot.setYRange(0.0, 1.0);
        this.slider = new JSlider(0);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setMinimum(1);
        this.slider.setSnapToTicks(true);
        this.slider.addChangeListener(new SliderMonitor());
        this.sdLabelTable = new Hashtable();
        int i = 0;
        while (i < 6) {
            this.sdLabelTable.put(new Integer(i + 1), new JLabel(String.valueOf(i * 2 + 1)));
            ++i;
        }
        this.psdLabelTable = new Hashtable();
        i = 1;
        while (i <= 48) {
            this.psdLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
            i += 3;
        }
        this.statusBar = new JPanel();
        this.currPointLabel = new JLabel();
        this.totalPointsLabel = new JLabel();
        this.xMap = null;
        this.yMap = this.dataMap.get("DATA");
        this.doorDetPoints = new TreeMap();
        this.psDetPoints = new TreeMap();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints mainConstraints = new GridBagConstraints();
        mainConstraints.gridx = 0;
        mainConstraints.gridy = 0;
        mainConstraints.fill = 2;
        mainConstraints.weightx = 1.0;
        mainConstraints.weighty = 0.0;
        JPanel toolPanel = new JPanel(new GridBagLayout());
        GridBagConstraints toolConstraints = new GridBagConstraints();
        toolConstraints.gridx = 0;
        toolConstraints.gridy = 0;
        toolConstraints.fill = 0;
        toolConstraints.weightx = 0.0;
        toolConstraints.insets = new Insets(0, 5, 0, 5);
        JLabel xVarLabel = new JLabel("X Variable:");
        String[] emptyList1 = new String[]{"N/A"};
        this.xVarComboBox = new JComboBox<String>(emptyList1);
        this.xVarComboBox.addItemListener(this);
        JLabel yVarLabel = new JLabel("Y Variable:");
        String[] emptyList2 = new String[]{"N/A"};
        this.yVarComboBox = new JComboBox<String>(emptyList2);
        this.yVarComboBox.addItemListener(this);
        toolPanel.add((Component)xVarLabel, toolConstraints);
        ++toolConstraints.gridx;
        toolPanel.add((Component)this.xVarComboBox, toolConstraints);
        ++toolConstraints.gridx;
        toolPanel.add((Component)yVarLabel, toolConstraints);
        ++toolConstraints.gridx;
        toolPanel.add((Component)this.yVarComboBox, toolConstraints);
        JPanel sliderPanel = new JPanel(new GridBagLayout());
        Bag sliderConstraints = new Bag();
        this.sliderLabel = new JLabel("undefined");
        sliderPanel.add((Component)this.sliderLabel, sliderConstraints.cell(0, 0).fillnone());
        sliderPanel.add((Component)this.slider, sliderConstraints.cell(0, 1).fillx(1.0));
        JTaskPaneGroup plotPanel2 = new JTaskPaneGroup();
        plotPanel2.setTitle("Plot 1");
        plotPanel2.setLayout(new GridBagLayout());
        Bag plotBag = new Bag();
        int x = 0;
        int y = 0;
        plotPanel2.add((Component)this.plot, plotBag.cell(x, y));
        plotPanel2.add((Component)toolPanel, plotBag.cell(x, ++y));
        this.secondaryPlotPanel = new JTaskPaneGroup();
        this.secondaryPlotPanel.setLayout(new GridBagLayout());
        Bag secondaryPlotBag = new Bag();
        y = 0;
        x = 0;
        this.secondaryPlotPanel.setTitle("Plot 2");
        this.secondaryPlotPanel.add((Component)this.secondaryPlot, secondaryPlotBag.cell(x, y));
        this.secondaryPlotPanel.add((Component)sliderPanel, secondaryPlotBag.cell(x, ++y));
        mainPanel.add((Component)plotPanel2, mainConstraints);
        ++mainConstraints.gridy;
        mainPanel.add((Component)this.secondaryPlotPanel, mainConstraints);
        ++mainConstraints.gridy;
        mainConstraints.fill = 3;
        mainConstraints.weighty = 1.0;
        mainPanel.add((Component)new JLabel(""), mainConstraints);
        this.add(mainPanel);
        this.initState();
        this.buildStatusBar();
    }

    private void initState() {
        new UpdateSecondaryPlotPanelState(this.lastScanDetectorMode).run();
    }

    private void buildStatusBar() {
        this.statusBar.setLayout(new BoxLayout(this.statusBar, 0));
        this.currPointLabel.setText("Current Point: N/A");
        this.totalPointsLabel.setText("Total Points: N/A");
        this.statusBar.add(this.currPointLabel);
        this.statusBar.add(new JLabel(", "));
        this.statusBar.add(this.totalPointsLabel);
        this.layeredStatusPane.add((Component)this.statusBar, new Integer(1));
        this.layeredStatusPane.revalidate();
    }

    protected void setupForNewScan(int numPoints, String filename, ArrayList<String> deviceList) {
        this.numScanPoints = numPoints;
        ArrayList<String> devices = new ArrayList<String>(deviceList);
        logger.debug("new XPeek set");
        this.clearGraphs("File: " + filename);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiveDataPanel.this.slider.setValue(1);
            }
        });
        this.doorDetPoints.clear();
        this.psDetPoints.clear();
        this.currPointLabel.setText("Current Point: N/A");
        this.totalPointsLabel.setText("Total Points: " + this.numScanPoints);
        this.dataMap = new TreeMap();
        this.dataMap.put("DATA", new TreeMap());
        this.yMap = this.dataMap.get("DATA");
        ArrayList<String> scanVars = new ArrayList<String>();
        scanVars.add("DATA");
        int i = 0;
        while (i < devices.size()) {
            scanVars.add(devices.get(i));
            this.dataMap.put(devices.get(i), new TreeMap());
            if (i == 0) {
                this.xMap = this.dataMap.get(devices.get(i));
            }
            ++i;
        }
        if (this.instrument.getDetectorMode() == Instrument.DetectorMode.DIFFRACTIONDETECTOR) {
            scanVars.add("DDCSUM");
            this.dataMap.put("DDCSUM", new TreeMap());
        } else if (this.instrument.getDetectorMode() == Instrument.DetectorMode.SINGLEDETECTOR) {
            scanVars.add("SDCSUM");
            scanVars.add("TDCSUM");
            this.dataMap.put("SDCSUM", new TreeMap());
            this.dataMap.put("TDCSUM", new TreeMap());
        } else if (this.instrument.getDetectorMode() == Instrument.DetectorMode.POSITIONSENSITIVEDETECTOR) {
            scanVars.add("PSDSUM");
            this.dataMap.put("PSDSUM", new TreeMap());
        }
        Thread thread1 = new Thread(new UpdateScanVars(this.xVarComboBox, scanVars));
        SwingUtilities.invokeLater(thread1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LiveDataPanel.this.xVarComboBox.getModel().getSize() > 1) {
                    LiveDataPanel.this.xVarComboBox.setSelectedIndex(1);
                }
            }
        });
        Thread thread2 = new Thread(new UpdateScanVars(this.yVarComboBox, scanVars));
        SwingUtilities.invokeLater(thread2);
        Instrument.DetectorMode currDetectorMode = this.instrument.getDetectorMode();
        if (this.lastScanDetectorMode != currDetectorMode) {
            new UpdateSecondaryPlotPanelState(currDetectorMode).run();
            this.lastScanDetectorMode = currDetectorMode;
        }
    }

    @Override
    public synchronized void actionPerformed(DataMessageEvent dme) {
        if (dme.isNewStart()) {
            this.setupForNewScan(dme.getNumPoints(), dme.getFilename(), dme.getDevices());
        } else if (!dme.hasFitData()) {
            String suffix;
            int pointNum = dme.getPointNum();
            this.currPointLabel.setText("Current Point: " + pointNum);
            Map<String, Double> pointMap = dme.getPointMap();
            if (pointMap == null) {
                logger.error("New point received: pointMap is null");
                return;
            }
            for (String key : pointMap.keySet()) {
                Double point = pointMap.get(key);
                TreeMap<Integer, Double> deviceMap = this.dataMap.get(key);
                if (deviceMap != null) {
                    deviceMap.put(new Integer(pointNum), point);
                    continue;
                }
                logger.error("Invalid point.  Device \"" + key + "\" does not match any declared " + "in new point declaration.  Ignoring");
            }
            if (this.lastScanDetectorMode == Instrument.DetectorMode.SINGLEDETECTOR) {
                try {
                    Double sdcSum = 0.0;
                    int i = 0;
                    while (i < 3) {
                        sdcSum = sdcSum + this.dataMap.get("SDC" + i).get(pointNum);
                        ++i;
                    }
                    this.dataMap.get("SDCSUM").put(pointNum, sdcSum);
                }
                catch (NullPointerException npe) {
                    logger.error("Single Detector point(s) were missing from map.  Unable to sum.  This shouldn't happen.", npe);
                }
                try {
                    Double tdcSum = 0.0;
                    int i = 0;
                    while (i < 11) {
                        tdcSum = tdcSum + this.dataMap.get("TDC" + i).get(pointNum);
                        ++i;
                    }
                    this.dataMap.get("TDCSUM").put(pointNum, tdcSum);
                }
                catch (NullPointerException npe) {
                    logger.error("Door Detector point(s) were missing from map.  Unable to sum.  This shouldn't happen.", npe);
                }
            } else if (this.lastScanDetectorMode == Instrument.DetectorMode.DIFFRACTIONDETECTOR) {
                try {
                    Double ddcSum = 0.0;
                    int i = 0;
                    while (i < 3) {
                        ddcSum = ddcSum + this.dataMap.get("DDC" + i).get(pointNum);
                        ++i;
                    }
                    this.dataMap.get("DDCSUM").put(pointNum, ddcSum);
                }
                catch (NullPointerException npe) {
                    logger.error("Diffraction Detector point(s) were missing from map.  Unable to sum.  This shouldn't happen.", npe);
                }
            } else if (this.lastScanDetectorMode == Instrument.DetectorMode.POSITIONSENSITIVEDETECTOR) {
                try {
                    Double psdSum = 0.0;
                    int i = 0;
                    while (i < 48) {
                        psdSum = psdSum + this.dataMap.get("PSDC" + i).get(pointNum);
                        ++i;
                    }
                    this.dataMap.get("PSDSUM").put(pointNum, psdSum);
                }
                catch (NullPointerException npe) {
                    logger.error("Position Sensitive Detector point(s) were missing from map.  Unable to sum.  This shouldn't happen.", npe);
                }
            }
            if (this.xMap != null && this.yMap != null) {
                logger.debug("xMap and yMap not null.");
                Double x = this.xMap.get(pointNum);
                Double y = this.yMap.get(pointNum);
                if (x != null && y != null) {
                    this.plotPoint(0, x, y);
                } else {
                    logger.error("Error: Unable to get points to plot.  This probably shouldn't happen.");
                }
            }
            if (this.lastScanDetectorMode == Instrument.DetectorMode.SINGLEDETECTOR) {
                TreeMap<Integer, Double> tdcPoints = new TreeMap<Integer, Double>();
                int i = 0;
                while (i < 11) {
                    suffix = String.format("%02d", i);
                    Double tdc = pointMap.get("TDC" + suffix);
                    tdcPoints.put(i, tdc);
                    ++i;
                }
                this.doorDetPoints.put(pointNum, tdcPoints);
                this.plotDDPoint(pointNum, (this.slider.getValue() - 1) * 2 + 1);
            } else if (this.lastScanDetectorMode == Instrument.DetectorMode.POSITIONSENSITIVEDETECTOR) {
                TreeMap<Integer, Double> psdPoints = new TreeMap<Integer, Double>();
                int i = 0;
                while (i < 48) {
                    suffix = String.format("%02d", i);
                    Double tdc = pointMap.get("PSDC" + suffix);
                    psdPoints.put(i, tdc);
                    ++i;
                }
                this.psDetPoints.put(pointNum, psdPoints);
                if (pointNum == this.slider.getValue()) {
                    this.plotPSDPoints(pointNum);
                }
            }
        }
    }

    private synchronized void plotPoint(int dataset, double x, double y) {
        SwingUtilities.invokeLater(new PlotPanel.PlotPoint(this.plot, dataset, x, y, false, y - Math.sqrt(y), y + Math.sqrt(y), true));
    }

    public synchronized void clearGraphs(String title) {
        logger.debug("Clearing graph.");
        SwingUtilities.invokeLater(new PlotPanel.ClearGraph(this.plot, title));
        SwingUtilities.invokeLater(new PlotPanel.ClearGraph(this.secondaryPlot, title));
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            JComboBox cb = (JComboBox)ie.getSource();
            String selectedVar = (String)cb.getSelectedItem();
            logger.debug("selectedVar: " + selectedVar);
            if (cb == this.xVarComboBox) {
                logger.debug("xmap combo box change");
                this.xMap = this.dataMap.get(selectedVar);
            } else if (cb == this.yVarComboBox) {
                logger.debug("ymap combo box change");
                this.yMap = this.dataMap.get(selectedVar);
            }
            this.replotGraph();
        }
    }

    public synchronized void replotGraph() {
        PlotPanel.ClearGraph clearGraph = new PlotPanel.ClearGraph(this.plot, null);
        SwingUtilities.invokeLater(clearGraph);
        for (Integer pt : this.xMap.keySet()) {
            Double x = this.xMap.get(pt);
            Double y = this.yMap.get(pt);
            if (x != null && y != null) {
                this.plotPoint(0, x, y);
                continue;
            }
            logger.error("For some reason unable to replot graph (x or y point is null, prolly y): (" + x + ", " + y + ").");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource() == this.instrument && "detectorMode".equals(pce.getPropertyName())) {
            logger.debug("instrument mode changed.");
            this.lastScanDetectorMode = this.instrument.getDetectorMode();
            new UpdateSecondaryPlotPanelState(this.lastScanDetectorMode).run();
        }
    }

    protected void plotDDPoint(long xPoint, int numToSum) {
        if (numToSum < 1 || numToSum > 11 || numToSum % 2 == 0) {
            throw new IllegalArgumentException("Number (" + numToSum + ") must be between 1 and 11, and must be odd.");
        }
        TreeMap<Integer, Double> pointMap = this.doorDetPoints.get(Long.valueOf(xPoint).intValue());
        try {
            double sum = pointMap.get(5);
            int leftIndex = 4;
            int rightIndex = 6;
            int i = 3;
            while (i <= numToSum) {
                sum += pointMap.get(leftIndex) + pointMap.get(rightIndex);
                --leftIndex;
                ++rightIndex;
                i += 2;
            }
            PlotPanel.PlotPoint plotPoint = new PlotPanel.PlotPoint(this.secondaryPlot, 0, xPoint, sum, false, sum - Math.sqrt(sum), sum + Math.sqrt(sum), true);
            SwingUtilities.invokeLater(plotPoint);
        }
        catch (NullPointerException npe) {
            logger.error("Null point.  Probably from a previous scan in non-SD mode.  Ignoring.");
        }
    }

    protected void plotPSDPoints(long scanPoint) {
        logger.debug("scanPoint: " + scanPoint);
        SwingUtilities.invokeLater(new PlotPanel.ClearGraph(this.secondaryPlot));
        TreeMap<Integer, Double> pointMap = this.psDetPoints.get(Long.valueOf(scanPoint).intValue());
        if (pointMap != null) {
            for (int x : pointMap.keySet()) {
                double y = pointMap.get(x);
                SwingUtilities.invokeLater(new PlotPanel.PlotPoint(this.secondaryPlot, 0, x, y, false, y - Math.sqrt(y), y + Math.sqrt(y), true));
            }
        }
    }

    @Override
    public void updateLockState() {
    }

    private class SliderMonitor
    implements ChangeListener {
        private SliderMonitor() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            JSlider source = (JSlider)ce.getSource();
            int value = source.getValue();
            if (LiveDataPanel.this.lastScanDetectorMode == Instrument.DetectorMode.SINGLEDETECTOR) {
                int numDetectors = (value - 1) * 2 + 1;
                if (numDetectors == LiveDataPanel.this.currentSum) {
                    return;
                }
                LiveDataPanel.this.currentSum = numDetectors;
                SwingUtilities.invokeLater(new PlotPanel.ClearGraph(LiveDataPanel.this.secondaryPlot, null));
                Set xPoints = LiveDataPanel.this.doorDetPoints.keySet();
                Iterator xPointIterator = xPoints.iterator();
                while (xPointIterator.hasNext()) {
                    long xPoint = ((Integer)xPointIterator.next()).longValue();
                    LiveDataPanel.this.plotDDPoint(xPoint, numDetectors);
                }
            } else if (LiveDataPanel.this.lastScanDetectorMode == Instrument.DetectorMode.POSITIONSENSITIVEDETECTOR) {
                int scanPoint = LiveDataPanel.this.slider.getValue();
                LiveDataPanel.this.plotPSDPoints(scanPoint);
            }
        }
    }

    private class UpdateScanVars
    implements Runnable {
        private JComboBox scanVarComboBox;
        private ArrayList<String> scanVars;

        public UpdateScanVars(JComboBox scanVarComboBox, ArrayList<String> scanVars) {
            this.scanVarComboBox = scanVarComboBox;
            this.scanVars = scanVars;
        }

        @Override
        public void run() {
            this.scanVarComboBox.removeAllItems();
            int i = 0;
            while (i < this.scanVars.size()) {
                this.scanVarComboBox.addItem(this.scanVars.get(i));
                ++i;
            }
        }
    }

    private class UpdateSecondaryPlotPanelState
    implements Runnable {
        private Instrument.DetectorMode detectorMode;

        public UpdateSecondaryPlotPanelState(Instrument.DetectorMode detectorMode) {
            this.detectorMode = detectorMode;
        }

        @Override
        public void run() {
            if (this.detectorMode == Instrument.DetectorMode.SINGLEDETECTOR) {
                LiveDataPanel.this.secondaryPlot.setXLabel("Point Number");
                LiveDataPanel.this.sliderLabel.setText(I18N.getString("liveData.slider.sdMode.label"));
                LiveDataPanel.this.slider.setMaximum(6);
                LiveDataPanel.this.slider.setLabelTable(LiveDataPanel.this.sdLabelTable);
            } else if (this.detectorMode == Instrument.DetectorMode.POSITIONSENSITIVEDETECTOR) {
                LiveDataPanel.this.secondaryPlot.setXLabel("Detector Number");
                LiveDataPanel.this.sliderLabel.setText(I18N.getString("liveData.slider.psdMode.label"));
                LiveDataPanel.this.slider.setMaximum(16);
                LiveDataPanel.this.slider.setLabelTable(LiveDataPanel.this.psdLabelTable);
            } else if (this.detectorMode == Instrument.DetectorMode.DIFFRACTIONDETECTOR || this.detectorMode == Instrument.DetectorMode.UNKNOWN) {
                LiveDataPanel.this.secondaryPlotPanel.setExpanded(false);
            }
        }
    }
}

