/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class TextPrinter
implements Printable {
    public static final int DEFAULT_FONT_SIZE = 8;
    public static final String DEFAULT_FONT_NAME = "Currier New";
    private PrinterJob job;
    private String typeName;
    private int typeSize;
    private Font typeFont;
    private Font typeFontBold;
    private String[] header;
    private String[] body;

    public TextPrinter() {
        this(DEFAULT_FONT_NAME, 8);
    }

    public TextPrinter(String name, int size) {
        if (size < 3 || size > 127) {
            throw new IllegalArgumentException("Type size out of range");
        }
        this.typeName = name;
        this.typeSize = size;
        this.typeFont = new Font(this.typeName, 0, this.typeSize);
        this.typeFontBold = new Font(this.typeName, 1, this.typeSize);
        this.job = null;
    }

    protected void init() {
        this.job = PrinterJob.getPrinterJob();
    }

    public int getCharsPerLine() {
        if (this.job == null) {
            this.init();
        }
        PageFormat pf = this.job.defaultPage();
        double width = pf.getImageableWidth();
        double ptsize = this.typeFont.getSize();
        double ptwid = ptsize * 3.0 / 4.0;
        double cnt = width / ptwid;
        return (int)Math.round(cnt);
    }

    public boolean doPrint(String[] header, String[] body, boolean interactive) throws PrinterException {
        if (this.job == null) {
            this.init();
        }
        if (interactive) {
            try {
                if (!this.job.printDialog()) {
                    return false;
                }
            }
            catch (Exception pe) {
                System.err.println("Could not pop up print dialog");
            }
        }
        this.job.setPrintable(this);
        this.header = header;
        this.body = body;
        this.job.print();
        this.job = null;
        return true;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int i;
        if (pageIndex != 0) {
            return 1;
        }
        graphics.setFont(this.typeFont);
        graphics.setColor(Color.black);
        FontMetrics fm = graphics.getFontMetrics();
        double x = pageFormat.getImageableX();
        double y = pageFormat.getImageableY() + (double)fm.getMaxAscent();
        if (this.header != null) {
            graphics.setFont(this.typeFontBold);
            i = 0;
            while (i < this.header.length) {
                graphics.drawString(this.header[i], (int)x, (int)y);
                y += (double)fm.getHeight();
                ++i;
            }
        }
        if (this.body != null) {
            graphics.setFont(this.typeFont);
            i = 0;
            while (i < this.body.length) {
                graphics.drawString(this.body[i], (int)x, (int)y);
                y += (double)fm.getHeight();
                ++i;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        TextPrinter tp = new TextPrinter();
        try {
            String[] headers = new String[]{"PRINT TEST"};
            String[] body = new String[]{"test", "this", "CODE"};
            boolean didit = tp.doPrint(headers, body, true);
            System.out.println("doPrint returns " + didit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

