/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.exceptions.IcePanelException;
import ice.gui.core.IceDialog;
import ice.gui.panel.sans.actions.SansButtonAction;
import ice.gui.panel.sans.subpanels.autodata.RangePanel;
import ice.swing.buttons.KeyResponseButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JTable;

public class RangeDialog
extends IceDialog
implements ActionListener {
    private static final String TITLE_KEY = "Run Properties";
    private static final long serialVersionUID = 1L;
    private static RangeDialog instance;
    private RangePanel rangePanel;
    protected JTable runTableList;

    private RangeDialog(Frame arg0, JTable table) throws HeadlessException, IcePanelException {
        super(arg0);
        this.init(table);
    }

    private void init(JTable table) throws IcePanelException {
        this.runTableList = table;
        this.setLayout(new BorderLayout());
        this.rangePanel = new RangePanel(this, table);
        this.add((Component)this.rangePanel, "Center");
        this.pack();
        this.setResizable(false);
    }

    private void populateRangePanel(JTable table, SansButtonAction action) {
        int[] selection = table.getSelectedRows();
        int low = 0;
        int high = 0;
        if (selection.length > 0) {
            low = selection[0];
            high = selection[selection.length - 1];
        }
        this.rangePanel.populateRangePanel(low + 1, high + 1, action);
        this.setTitle(action.getName());
    }

    public static RangeDialog getInstance(JFrame parent, JTable table, SansButtonAction action) {
        if (instance == null) {
            try {
                instance = new RangeDialog((Frame)parent, table);
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (IcePanelException e) {
                e.printStackTrace();
            }
            instance.setDefaultCloseOperation(2);
            instance.centerOnParent();
        }
        instance.populateRangePanel(table, action);
        RangeDialog.instance.rangePanel.listenToButtons(instance);
        instance.setModal(true);
        instance.setVisible(true);
        RangeDialog.instance.runTableList.grabFocus();
        return instance;
    }

    public static RangeDialog getInstance() {
        return instance;
    }

    public RangePanel getRangePanel() {
        return this.rangePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof KeyResponseButton) {
            this.setVisible(false);
        }
    }
}

