/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.DeviceAddCommand;
import ice.commands.DeviceDestroyCommand;
import ice.commands.DeviceSetPropertyCommand;
import ice.commands.MoveCommand;
import ice.communication.SendQueueManager;
import ice.data.AvailableMagnetDevice;
import ice.data.AvailableMiscDevice;
import ice.data.AvailablePressureDevice;
import ice.data.AvailableTempDevice;
import ice.data.InstalledDevice;
import ice.data.InstalledMagnetDevice;
import ice.event.AvailableDeviceEvent;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.communication.AvailableDeviceListListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.gui.panel.sans.controls.SansDeviceComboBoxControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlDoubleNoScalePanel;
import ice.gui.panel.sans.subpanels.MagneticPanel;
import ice.gui.panel.sans.subpanels.SampleMagneticField;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class SuperConductingMagneticPanel
extends MagneticPanel
implements DeviceListListener,
AvailableDeviceListListener,
DeviceValueChangedListener {
    public static final String N_A_MENU_LABEL = "N/A";
    public static final String MAG_FIELD_ALIAS_NAME = "MagField";
    protected List<AvailableMagnetDevice> availableDeviceList;
    protected CurrentMagnetControlPanel currentDeviceControlPanel;
    protected SansDeviceComboBoxControlPanel persistenceMode;
    protected SansDeviceControlDoubleNoScalePanel magneticField;
    protected SansDeviceControlDoubleNoScalePanel maxWaitTime;
    protected String rememberCurrentSelection;
    protected InstalledMagnetDevice currentDevice;
    private static Logger logger = Logger.getLogger("ErrorLogger");

    public SuperConductingMagneticPanel() {
        this.init();
    }

    public void init() {
        String[] persistenceItems = new String[]{"", "Yes", "No"};
        this.currentDeviceControlPanel = new CurrentMagnetControlPanel("Current Magnet", MAG_FIELD_ALIAS_NAME, true);
        this.persistenceMode = new SansDeviceComboBoxControlPanel("Persistence mode", MAG_FIELD_ALIAS_NAME, false);
        this.persistenceMode.addItems(persistenceItems);
        this.magneticField = new SansDeviceControlDoubleNoScalePanel("Magnetic field", MAG_FIELD_ALIAS_NAME, false);
        this.maxWaitTime = new SansDeviceControlDoubleNoScalePanel("Max. wait time for ramping (sec)", MAG_FIELD_ALIAS_NAME, false);
        Controller controller = null;
        SendQueueManager sendManager = null;
        controller = Controller.getReference();
        try {
            controller.getCommMgr().addAvailableDeviceListListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("SuperConductingMagneticPanel.init " + e);
        }
        sendManager = controller.getSendManager();
        controller.getDeviceListeners().add(this);
        this.findCurrentMagnetDevice();
        sendManager.addMessage("ask GETAVAILABLEDEVICEDEFAULTS getdevicedefaults magnet", false);
        this.buildGUI();
    }

    public void buildGUI() {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.currentDeviceControlPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.persistenceMode, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.magneticField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.maxWaitTime, gridBagConstraints);
        this.readControlKeysFromHelpPreferenceFile();
    }

    @Override
    public void addKeyListenerToTarget(KeyListener l) {
        this.magneticField.addKeyListener(l);
    }

    @Override
    public KeyListener[] getTargetsKeyListeners() {
        KeyListener[] keyListeners = null;
        keyListeners = this.magneticField.getTargetsKeyListeners();
        return keyListeners;
    }

    @Override
    public void addTargetsKeyListeners(KeyListener[] keyListeners) {
        this.magneticField.addTargetsKeyListeners(keyListeners);
    }

    @Override
    public String getTargetValue() {
        String returnValue = "";
        returnValue = this.magneticField.getTargetValue();
        return returnValue;
    }

    @Override
    public void removeTargetKeyListeners() {
        this.magneticField.removeTargetKeyListeners();
    }

    @Override
    public void preformMove() {
        block12: {
            if (this.currentDevice == null) {
                return;
            }
            MoveCommand moveCommand = null;
            String magneticField = "";
            String persistanceString = "";
            String maxWaitTime = "";
            String theCommand = "-presetdevicesproperties \"";
            String currentDeviceName = "";
            magneticField = this.magneticField.getTargetValue();
            persistanceString = this.persistenceMode.getCurrentValue();
            if (!persistanceString.equals("")) {
                persistanceString = persistanceString.equals("Yes") ? "1" : "0";
            }
            maxWaitTime = this.maxWaitTime.getTargetValue();
            currentDeviceName = this.currentDevice.getRealName();
            if (currentDeviceName != null) {
                boolean succeeded = false;
                try {
                    try {
                        Hashtable<String, String> properties = new Hashtable<String, String>();
                        if (magneticField == null || magneticField.equals("")) break block12;
                        try {
                            double newPosition = Double.parseDouble(magneticField);
                            properties.put("persistenceMode", persistanceString);
                            properties.put("timeout", maxWaitTime);
                            String value = null;
                            Set keys = null;
                            keys = properties.keySet();
                            for (String key : keys) {
                                value = (String)properties.get(key);
                                if (value == null || value.equals("")) continue;
                                DeviceSetPropertyCommand deviceSetPropertyCommand = null;
                                deviceSetPropertyCommand = new DeviceSetPropertyCommand(currentDeviceName, key, value);
                                deviceSetPropertyCommand.runAsynchronous();
                                boolean bl = succeeded = !deviceSetPropertyCommand.isError() && deviceSetPropertyCommand.isSuccess();
                                if (succeeded) continue;
                                logger.debug(deviceSetPropertyCommand.getResponse());
                            }
                            properties = null;
                            moveCommand = new MoveCommand(currentDeviceName, newPosition);
                            moveCommand.runAsynchronous();
                            boolean bl = succeeded = !moveCommand.isError() && moveCommand.isSuccess();
                            if (!succeeded) {
                                logger.debug(moveCommand.getResponse());
                            }
                        }
                        catch (NumberFormatException e) {
                            logger.error(e.toString());
                        }
                    }
                    catch (NoClientAPIInstanceException e) {
                        logger.error(e.toString());
                        this.clearTargets();
                    }
                }
                finally {
                    this.clearTargets();
                }
            }
        }
    }

    public void clearTargets() {
        this.magneticField.setTargetValue("");
        this.persistenceMode.setTargetValue("");
        this.maxWaitTime.setTargetValue("");
    }

    @Override
    public void removeKeyListenerFromTarget(KeyListener l) {
        this.magneticField.addKeyListenerToTarget(l);
    }

    protected void setValuesFrom(InstalledMagnetDevice theDevice) {
        String deviceName = "";
        String currentValue = "";
        String maxWaitTime = "";
        String persistanceMode = "";
        if (theDevice != null) {
            Double temp = 0.0;
            deviceName = theDevice.getRealName();
            currentValue = theDevice.getCurrValue();
            temp = theDevice.getTimeout();
            if (temp != null) {
                maxWaitTime = temp.toString();
            }
            persistanceMode = theDevice.isPersistenceMode() != false ? "Yes" : "No";
        }
        this.currentDeviceControlPanel.setCurrentValue(deviceName);
        this.magneticField.setCurrentValue(currentValue);
        this.maxWaitTime.setCurrentValue(maxWaitTime);
        this.persistenceMode.setCurrentValue(persistanceMode);
        if (currentValue.equals("")) {
            KeyListener[] keyListeners;
            KeyListener[] keyListenerArray = keyListeners = this.getTargetsKeyListeners();
            int n = keyListeners.length;
            int n2 = 0;
            while (n2 < n) {
                KeyListener l = keyListenerArray[n2];
                if (l instanceof SampleMagneticField) {
                    KeyEvent e = new KeyEvent(this, 0, 0L, 0, 0, 'a');
                    l.keyReleased(e);
                }
                ++n2;
            }
        }
    }

    protected void enableInputControls(boolean enable) {
        this.magneticField.setEnabled(enable);
        this.persistenceMode.setEnabled(enable);
        this.maxWaitTime.setEnabled(enable);
        if (!enable) {
            this.magneticField.setTargetValue("");
            this.persistenceMode.setTargetValue("");
            this.maxWaitTime.setTargetValue("");
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        List<InstalledDevice> installedDevices = null;
        String alias2 = null;
        String realName = null;
        installedDevices = dle.getDevicesRemoved();
        for (InstalledDevice removeMe : installedDevices) {
            if (!(removeMe instanceof InstalledMagnetDevice)) continue;
            alias2 = removeMe.getAlias();
            realName = removeMe.getRealName();
            if (removeMe != this.currentDevice) continue;
            removeMe.removeValueChangeListener(this);
            this.currentDevice = null;
            this.setValuesFrom(this.currentDevice);
            this.enableInputControls(false);
        }
        installedDevices = dle.getDevicesAdded();
        for (InstalledDevice addMe : installedDevices) {
            if (!(addMe instanceof InstalledMagnetDevice)) continue;
            this.currentDevice = (InstalledMagnetDevice)addMe;
            this.setValuesFrom(this.currentDevice);
            this.enableInputControls(true);
            try {
                this.currentDevice.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("SuperConductionMagnetic.deviceListUpdated " + e);
            }
        }
    }

    protected void findCurrentMagnetDevice() {
        Controller controller = null;
        boolean found = false;
        boolean foundBlueBox = false;
        controller = Controller.getReference();
        ArrayList<InstalledDevice> allDevices = controller.getDeviceList();
        this.enableInputControls(false);
        for (InstalledDevice aDevice : allDevices) {
            if (!(aDevice instanceof InstalledMagnetDevice)) continue;
            String name = aDevice.getRealName();
            String currentValue = aDevice.getCurrValue();
            try {
                aDevice.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("SuperConductionMagnet.fingCurrentMangentDevice " + e);
            }
            this.currentDevice = (InstalledMagnetDevice)aDevice;
            this.setValuesFrom(this.currentDevice);
            this.enableInputControls(true);
        }
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        Object source = evt.getSource();
        if (source instanceof InstalledMagnetDevice) {
            Object newValue;
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("currValue")) {
                newValue = (String)evt.getNewValue();
                this.magneticField.setCurrentValue((String)newValue);
            }
            if (propertyName.equals("fixed")) {
                newValue = (Boolean)evt.getNewValue();
                this.currentDeviceControlPanel.setFixed((Boolean)newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FillAvailableMagnetDeviceComboBox() {
        SuperConductingMagneticPanel superConductingMagneticPanel = this;
        synchronized (superConductingMagneticPanel) {
            this.rememberCurrentSelection = this.currentDeviceControlPanel.getTargetValue();
            if (this.availableDeviceList != null && this.availableDeviceList.size() > 0) {
                this.currentDeviceControlPanel.removeAllItems();
                this.currentDeviceControlPanel.addItem("");
                for (AvailableMagnetDevice magnetDevice : this.availableDeviceList) {
                    boolean hasKey = false;
                    String name = null;
                    name = magnetDevice.toString().toUpperCase();
                    hasKey = false;
                    if (hasKey) continue;
                    this.currentDeviceControlPanel.addItem(magnetDevice.getName());
                }
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            if (this.currentDeviceControlPanel.getTargetItemCount() > 0) {
                this.currentDeviceControlPanel.setTargetSelectedItem(this.rememberCurrentSelection);
            }
        }
    }

    @Override
    public void actionPerformed(AvailableDeviceEvent availableDeviceEvent) {
        AvailableDeviceEvent.Type theType = availableDeviceEvent.getTheType();
        List theList = availableDeviceEvent.getDeviceList();
        switch (theType) {
            case MAGNET: {
                this.receiveAvailableMagnetDevices(theList);
                break;
            }
            case OTHER: {
                this.receiveAvailableOtherDevices(theList);
                break;
            }
            case TEMP: {
                this.receiveAvailableTempDevices(theList);
                break;
            }
            case PRESSURE: {
                this.receiveAvailablePressureDevices(theList);
            }
        }
    }

    public void receiveAvailableMagnetDevices(List<AvailableMagnetDevice> devices) {
        this.availableDeviceList = devices;
        this.FillAvailableMagnetDeviceComboBox();
    }

    public void receiveAvailableOtherDevices(List<AvailableMiscDevice> devices) {
    }

    public void receiveAvailablePressureDevices(List<AvailablePressureDevice> devices) {
    }

    public void receiveAvailableTempDevices(List<AvailableTempDevice> devices) {
    }

    @Override
    public void setIcePanelAsParent() {
        this.currentDeviceControlPanel.setControlParent();
        this.persistenceMode.setControlParent();
        this.magneticField.setControlParent();
        this.maxWaitTime.setControlParent();
    }

    protected class CurrentMagnetControlPanel
    extends SansDeviceComboBoxControlPanel
    implements ActionListener {
        public static final String SET_ACTION = "SET_ACTION";
        protected JButton setButton;

        public CurrentMagnetControlPanel(String name, String deviceName, boolean showFixed) {
            super(name, deviceName, showFixed);
        }

        public CurrentMagnetControlPanel(String name, String deviceName, String units) {
            super(name, deviceName, units);
        }

        public CurrentMagnetControlPanel(String name, String deviceName) {
            super(name, deviceName);
        }

        @Override
        protected void init() {
            super.init();
            this.setButton = new JButton("Set");
            this.setButton.setActionCommand(SET_ACTION);
            this.setButton.addActionListener(this);
        }

        @Override
        public void buildGUI() {
            super.buildGUI();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(10, 0, 0, 10);
            this.add((Component)this.setButton, gridBagConstraints);
        }

        public void changeDevice() {
            String targetDevice = this.getTargetValue();
            String currDevice = this.getCurrentValue();
            if (currDevice != null && !currDevice.equals("")) {
                this.removeMagnetDeviceFromServer(currDevice);
            }
            if (targetDevice != null && !targetDevice.equals("")) {
                this.addMagnetDeviceToServer(targetDevice, true);
            }
            this.setTargetValue("");
        }

        protected void addMagnetDeviceToServer(String deviceName, boolean makeAlias) {
            DeviceAddCommand deviceAddCommand = null;
            try {
                String aliasName = makeAlias ? SuperConductingMagneticPanel.MAG_FIELD_ALIAS_NAME : null;
                deviceAddCommand = new DeviceAddCommand(deviceName, DeviceAddCommand.DeviceType.ENV, null, null, null, null, false, aliasName);
                deviceAddCommand.runAsynchronous();
                if (deviceAddCommand.isError()) {
                    String responseString = null;
                    responseString = deviceAddCommand.getResponse();
                    throw new Exception(responseString);
                }
                this.fixedBox.setEnabled(true);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }

        protected void removeMagnetDeviceFromServer(String deviceName) {
            DeviceDestroyCommand deviceDestroyCommand = null;
            try {
                deviceDestroyCommand = new DeviceDestroyCommand(deviceName);
                deviceDestroyCommand.runAsynchronous();
                this.fixedBox.setEnabled(false);
                this.fixedBox.setSelected(false);
                if (deviceDestroyCommand.isError()) {
                    String responseString = null;
                    responseString = deviceDestroyCommand.getResponse();
                    throw new Exception(responseString);
                }
                deviceDestroyCommand = new DeviceDestroyCommand(SuperConductingMagneticPanel.MAG_FIELD_ALIAS_NAME);
                deviceDestroyCommand.runAsynchronous();
                if (deviceDestroyCommand.isError()) {
                    String responseString = null;
                    responseString = deviceDestroyCommand.getResponse();
                    throw new Exception(responseString);
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand;
            Object source = e.getSource();
            if (source == this.setButton && (actionCommand = e.getActionCommand()).equals(SET_ACTION)) {
                this.changeDevice();
            }
        }

        @Override
        public void setCurrentValue(String value) {
            if (value.equals("")) {
                SuperConductingMagneticPanel.this.enableInputControls(false);
            } else {
                SuperConductingMagneticPanel.this.enableInputControls(true);
            }
            super.setCurrentValue(value);
        }
    }
}

