/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.buttons.MainMenuButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.swing.threadedUpdaters.UpdateLabel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.PreferencesManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MainMenuPanel
extends SansIcePanel
implements InstrumentValueChangedListener {
    private static final long serialVersionUID = -4455132897940578261L;
    public static final String menu = "MainMenu";
    private static final String title = "SANS Data Acquisition";
    public static final String defaultTimeZoneString = "defaultTimeZone";
    public static final String defaultTimeZoneValue = "America/New_York";
    private static Logger logger = Logger.getLogger("ErrorLogger.MainMenu");
    private MainMenuButtonControlPanel mainMenuButtonControl;
    private JLabel dateLabel;
    private JLabel instrumentLabel;
    private DateFormat dateFormat;
    private String instrumentName;

    public MainMenuPanel() throws IcePanelException {
        super(menu, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.titleLbl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.dateLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.instrumentLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(40, 0, 0, 0);
        this.add((Component)this.mainMenuButtonControl, gridBagConstraints);
        this.readButtonHintFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.dateLabel = new JLabel("Server Date is Unavailable");
        this.instrumentLabel = new JLabel();
        this.mainMenuButtonControl = new MainMenuButtonControlPanel(this);
        Controller controller = Controller.getReference();
        Instrument instrument = controller.getInstrument();
        this.dateFormat = DateFormat.getDateTimeInstance(2, 0);
        String timeZone = PreferencesManager.getPreferenceString(defaultTimeZoneString, defaultTimeZoneValue);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        String state = instrument.getState().getName();
        this.instrumentName = "Instrument: " + instrument.getName();
        this.instrumentLabel.setText(String.valueOf(this.instrumentName) + ":" + state.toUpperCase());
        try {
            instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("error adding listener", e);
        }
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent pce) {
        Instrument instrument = (Instrument)pce.getSource();
        String propertyName = pce.getPropertyName();
        if (propertyName.equals("time")) {
            String instrumentTime = this.dateFormat.format(instrument.getTime());
            SwingUtilities.invokeLater(new UpdateLabel(this.dateLabel, instrumentTime));
        } else if (propertyName.equals("state")) {
            Instrument.State instrumentState = instrument.getState();
            String state = String.valueOf(this.instrumentName) + ":" + instrumentState.getName().toUpperCase();
            SwingUtilities.invokeLater(new UpdateLabel(this.instrumentLabel, state));
        }
    }

    @Override
    public void updateDeviceControls() {
    }
}

