/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.ClientAPI;
import ice.Controller;
import ice.commands.DevicePositionsCommand;
import ice.data.InstalledDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.NumberOutOfRangeListener;
import ice.event.communication.EmptyDocumentListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.SansDeviceComboBoxControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlDoubleNoScalePanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.buttons.BeamstopButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.util.HelpPropertiesManager;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class BeamStopPanel
extends SansIcePanel
implements DeviceListListener {
    protected static final String BEAM_STOP_X_POSITION_NAME = "Beamstop X Position";
    protected static final String BEAM_STOP_Y_POSITION_NAME = "Beamstop Y Position";
    public static final String beamStopX = "BeamStopX";
    public static final String beamStopY = "BeamStopY";
    public static final String beamStopSize = "BeamStop";
    private static final String title = "BEAMSTOP SIZE/POSITION";
    private static Logger logger = Logger.getLogger("ErrorLogger.BeamStopPanel");
    private SansDeviceControlDoubleNoScalePanel beamstopXControl;
    private SansDeviceControlDoubleNoScalePanel beamstopYControl;
    private BeamstopButtonControlPanel buttonPanel;
    private ArrayList<InstalledDevice> allDevices;
    private Controller controller;
    private SansDeviceComboBoxControlPanel beamstopSizeControl;
    protected boolean beamStopXHasText;
    protected boolean beamStopYHasText;

    public BeamStopPanel() throws IcePanelException {
        super(beamStopSize, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.beamstopXControl, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.beamstopYControl, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.beamstopSizeControl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.writeKeysToHelpPreferenceFile();
        this.buttonPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.beamstopXControl = new SansDeviceControlDoubleNoScalePanel(BEAM_STOP_X_POSITION_NAME, beamStopX, false);
        this.beamstopXControl.listenToTargetEmptyDocumentEvent(this);
        this.beamstopYControl = new SansDeviceControlDoubleNoScalePanel(BEAM_STOP_Y_POSITION_NAME, beamStopY, false);
        this.beamstopYControl.listenToTargetEmptyDocumentEvent(this);
        this.beamstopSizeControl = new SansDeviceComboBoxControlPanel("Beamstop Size", beamStopSize, false);
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            DevicePositionsCommand iCommand = new DevicePositionsCommand(beamStopSize, messageSender);
            iCommand.runSynchronous();
            String[] values = iCommand.getParsedResponse();
            this.beamstopSizeControl.addItems(values);
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        this.buttonPanel = new BeamstopButtonControlPanel(this);
        this.helpPanel = new HelpPanel();
        this.controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.controller.getDeviceListeners().add(this);
        this.beamStopXHasText = false;
        this.beamStopYHasText = false;
        String key = String.valueOf(this.getClass().getName()) + "." + this.beamstopXControl.getControlName();
        String hint = HelpPropertiesManager.getPreferenceString(key);
        this.beamstopXControl.setHint(hint);
    }

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
        boolean buttonOn;
        super.documentChanged(e);
        SANSDecimalFormattedTextField textField = (SANSDecimalFormattedTextField)e.getSource();
        SansDeviceControlDoubleNoScalePanel parent = (SansDeviceControlDoubleNoScalePanel)textField.getParent();
        String name = parent.getControlName();
        EmptyDocumentListener.EmptyDocumentState state = e.getState();
        NumberOutOfRangeListener.NumberRange inRange = textField.inRange();
        if (state == EmptyDocumentListener.EmptyDocumentState.FORMATTING) {
            return;
        }
        boolean bl = buttonOn = state == EmptyDocumentListener.EmptyDocumentState.HAS_TEXT && inRange == NumberOutOfRangeListener.NumberRange.IN_RANGE;
        if (name != null && name.equals(BEAM_STOP_X_POSITION_NAME)) {
            this.beamStopXHasText = buttonOn;
        } else if (name != null && name.equals(BEAM_STOP_Y_POSITION_NAME)) {
            this.beamStopYHasText = buttonOn;
        }
        buttonOn = this.beamStopXHasText || this.beamStopYHasText;
        this.buttonPanel.enableMoveBeamStopPosButton(buttonOn);
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            Double min = Double.MIN_VALUE;
            Double max = Double.MAX_VALUE;
            if (device.getName().equalsIgnoreCase(beamStopX)) {
                device.removeValueChangeListener(this.beamstopXControl);
                continue;
            }
            if (device.getName().equalsIgnoreCase(beamStopY)) {
                device.removeValueChangeListener(this.beamstopYControl);
                continue;
            }
            if (!device.getName().equalsIgnoreCase(beamStopSize)) continue;
            device.removeValueChangeListener(this.beamstopSizeControl);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    @Override
    public void updateDeviceControls() {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            Double min = Double.MIN_VALUE;
            Double max = Double.MAX_VALUE;
            try {
                String currentValue;
                if (device.getName().equalsIgnoreCase(beamStopX)) {
                    device.addValueChangeListener(this.beamstopXControl);
                    currentValue = device.getCurrValue().toString();
                    this.beamstopXControl.setCurrentValue(currentValue);
                    min = device.getLowerLimit();
                    max = device.getUpperLimit();
                    this.beamstopXControl.setTargetMinMax(min, max);
                    continue;
                }
                if (device.getName().equalsIgnoreCase(beamStopY)) {
                    device.addValueChangeListener(this.beamstopYControl);
                    currentValue = device.getCurrValue().toString();
                    this.beamstopYControl.setCurrentValue(currentValue);
                    min = device.getLowerLimit();
                    max = device.getUpperLimit();
                    this.beamstopYControl.setTargetMinMax(min, max);
                    continue;
                }
                if (!device.getName().equalsIgnoreCase(beamStopSize)) continue;
                device.addValueChangeListener(this.beamstopSizeControl);
                currentValue = device.getCurrValue().toString();
                this.beamstopSizeControl.setCurrentValue(currentValue);
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("BeamStopPanel.updateDeviceControls " + e);
            }
        }
    }

    public SansDeviceControlPanel getBeamstopXControl() {
        return this.beamstopXControl;
    }

    public SansDeviceControlPanel getBeamstopYControl() {
        return this.beamstopYControl;
    }

    public SansDeviceControlPanel getBeamstopSizeControl() {
        return this.beamstopSizeControl;
    }
}

