/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.composite;

import ice.event.NumberOutOfRangeListener;
import ice.event.communication.EmptyDocumentListener;
import ice.gui.panel.sans.controls.composite.SansDeviceDefaultPropertyControl;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.swing.textFields.ICEDecimalFormattedTextField;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class SansDeviceFTFPropertyControl
extends SansDeviceDefaultPropertyControl
implements NumberOutOfRangeListener,
EmptyDocumentListener {
    private static final long serialVersionUID = -8623798604044073686L;
    private static Logger logger = Logger.getLogger("ErrorLogger.SansDeviceComboBoxPropertyControl");
    protected static final int DEFAULT_NUMBER_OF_FRACTIION_DIGITS = 3;

    public SansDeviceFTFPropertyControl(String deviceName) {
        super(deviceName, "currValue", "currValue");
    }

    @Override
    protected JComponent instantiateCurrentPropertyField() {
        SANSDecimalFormattedTextField field = new SANSDecimalFormattedTextField(3);
        return field;
    }

    @Override
    protected JComponent instantiateTargetPropertyField() {
        SANSDecimalFormattedTextField textField = null;
        textField = new SANSDecimalFormattedTextField(3);
        textField.setText("");
        textField.addNumberOutOfRangeListener(this);
        textField.addEmptyDocumentListener(this);
        return textField;
    }

    public void listenToTargetEmptyDocumentEvent(SansIcePanel sansIcePanel) {
    }

    @Override
    public void setCurrentValue(String value) {
        ((SANSDecimalFormattedTextField)this.currentValueComponent).setText(value);
    }

    @Override
    public String getCurrentValue() {
        String currentValue = ((SANSDecimalFormattedTextField)this.currentValueComponent).getText();
        return currentValue;
    }

    @Override
    public String getTargetValue() {
        String targetValue = ((SANSDecimalFormattedTextField)this.targetValueComponent).getText();
        return targetValue;
    }

    @Override
    public void setTargetValue(String value) {
        ((SANSDecimalFormattedTextField)this.targetValueComponent).setText(value);
    }

    public void setNumberOfFractionDigits(int numberOfFractionDigits) {
        ((ICEDecimalFormattedTextField)this.targetValueComponent).setNumberOfFractionDigits(numberOfFractionDigits);
        ((ICEDecimalFormattedTextField)this.currentValueComponent).setNumberOfFractionDigits(numberOfFractionDigits);
    }

    @Override
    public void handleOutOfRangeNumber(NumberOutOfRangeListener.NumberOutOfRangeEvent numberOutOfRangeEvent) {
        int id;
        ComponentEvent detectedOn = numberOutOfRangeEvent.getDetectedOn();
        NumberOutOfRangeListener.NumberRange state = numberOutOfRangeEvent.getState();
        if (detectedOn instanceof FocusEvent && state == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE) {
            int id2 = ((FocusEvent)detectedOn).getID();
            if (id2 == 1005) {
                SansIcePanel parent = this.getSansIcePanelParent();
                String message = "Target for " + this.getDeviceName() + " out of range. The value must be between " + numberOutOfRangeEvent.getMin() + " and " + numberOutOfRangeEvent.getMax() + ".";
                parent.setErrorText(message);
            }
        } else if (detectedOn instanceof FocusEvent && state == NumberOutOfRangeListener.NumberRange.IN_RANGE && (id = ((FocusEvent)detectedOn).getID()) == 1005) {
            SansIcePanel parent = this.getSansIcePanelParent();
            String message = "Target for " + this.getDeviceName() + " out of range. The value must be between " + numberOutOfRangeEvent.getMin() + " and " + numberOutOfRangeEvent.getMax() + ".";
            parent.clearErrors(message);
        }
    }

    public void setTargetMinMax(double min, double max) {
        ((ICEDecimalFormattedTextField)this.targetValueComponent).setMinValue(min);
        ((ICEDecimalFormattedTextField)this.targetValueComponent).setMaxValue(max);
    }

    @Override
    protected void setLowerLimit(Double currentValue) {
        ((ICEDecimalFormattedTextField)this.targetValueComponent).setMinValue(currentValue);
    }

    @Override
    protected void setUpperLimit(Double currentValue) {
        ((ICEDecimalFormattedTextField)this.targetValueComponent).setMaxValue(currentValue);
    }

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
        if (e.getSource() instanceof ICEDecimalFormattedTextField) {
            EmptyDocumentListener.EmptyDocumentState state = e.getState();
            NumberOutOfRangeListener.NumberRange inRange = ((ICEDecimalFormattedTextField)this.targetValueComponent).inRange();
            if (state == EmptyDocumentListener.EmptyDocumentState.FORMATTING) {
                return;
            }
            boolean buttonOn = state == EmptyDocumentListener.EmptyDocumentState.HAS_TEXT && inRange == NumberOutOfRangeListener.NumberRange.IN_RANGE;
            this.updateButton.setEnabled(buttonOn);
        }
    }
}

