/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.buttons;

import ice.gui.core.GenericIcePanel;
import ice.gui.panel.sans.actions.MoveDeviceAction;
import ice.gui.panel.sans.actions.ShowHuberTableAction;
import ice.gui.panel.sans.controls.SansButtonPanelControl;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.buttons.F20PreviousMenuButton;
import ice.gui.panel.sans.subpanels.SampleChangerPanel;
import ice.swing.buttons.KeyResponseButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

public class SampleChangerButtonControlPanel
extends SansButtonPanelControl {
    private static final String CHANGE_SAMPLE_TABLE_BUTTON_NAME = "F13: Change to Sample Table Screen";
    private static final String CHANGE_SAMPLE_TABLE_BUTTON_HINT = "Change to Sample Table Screen";
    private static final String MOVE_TO_TARGET_POSITION_BUTTON_NAME = "F17: Move to Target Position";
    private static final String MOVE_TO_TARGET_ROTATION_BUTTON_NAME = "F18: Move to Target Rotation Angle";
    private F20PreviousMenuButton backBtn;
    private KeyResponseButton changeSampleTableBtn;
    private KeyResponseButton moveToTargetRotAngleBtn;
    private KeyResponseButton moveToTargetPosBtn;
    private SampleChangerPanel samplePanel;

    public SampleChangerButtonControlPanel(GenericIcePanel parentPanel) {
        super(parentPanel);
    }

    @Override
    protected void init(GenericIcePanel panel) {
        super.init(panel);
        this.samplePanel = (SampleChangerPanel)panel;
        ShowHuberTableAction swapAction = new ShowHuberTableAction(CHANGE_SAMPLE_TABLE_BUTTON_NAME, CHANGE_SAMPLE_TABLE_BUTTON_HINT);
        this.changeSampleTableBtn = new KeyResponseButton(swapAction, CHANGE_SAMPLE_TABLE_BUTTON_NAME, 116);
        this.moveToTargetRotAngleBtn = new KeyResponseButton(MOVE_TO_TARGET_ROTATION_BUTTON_NAME, MOVE_TO_TARGET_ROTATION_BUTTON_NAME, 121);
        this.addToClearsErrors(this.moveToTargetRotAngleBtn);
        this.moveToTargetRotAngleBtn.setEnabled(false);
        this.moveToTargetPosBtn = new KeyResponseButton(MOVE_TO_TARGET_POSITION_BUTTON_NAME, MOVE_TO_TARGET_POSITION_BUTTON_NAME, 120);
        this.moveToTargetPosBtn.setEnabled(false);
        this.addToClearsErrors(this.moveToTargetPosBtn);
        this.backBtn = new F20PreviousMenuButton();
    }

    public void enableMoveToTargetRotAngleBtn(boolean enable) {
        this.moveToTargetRotAngleBtn.setEnabled(enable);
    }

    public void enableMoveToTargetPosBtn(boolean enable) {
        this.moveToTargetPosBtn.setEnabled(enable);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String buttonName = CHANGE_SAMPLE_TABLE_BUTTON_NAME;
        String hint = CHANGE_SAMPLE_TABLE_BUTTON_HINT;
        this.changeSampleTableBtn.setHorizontalAlignment(2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.changeSampleTableBtn.setText(CHANGE_SAMPLE_TABLE_BUTTON_NAME);
        this.add((Component)this.changeSampleTableBtn, gridBagConstraints);
        buttonName = MOVE_TO_TARGET_POSITION_BUTTON_NAME;
        hint = "<html>Move to Target Position<br>\nmoves the sample changer to the target value</html>";
        SansDeviceControlPanel control = this.samplePanel.getSamplePositionPanel();
        MoveDeviceAction moveAction = new MoveDeviceAction(control);
        this.moveToTargetPosBtn.addActionListener(moveAction);
        this.moveToTargetPosBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.moveToTargetPosBtn, gridBagConstraints);
        buttonName = MOVE_TO_TARGET_ROTATION_BUTTON_NAME;
        hint = "<html>Move to Target Rotation Angle <br>\nrotates the sample to the target value.</html>";
        SansDeviceControlPanel controlRot = this.samplePanel.getSampleRotaitonPanel();
        MoveDeviceAction moveRotAction = new MoveDeviceAction(controlRot);
        this.moveToTargetRotAngleBtn.addActionListener(moveRotAction);
        this.moveToTargetRotAngleBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.moveToTargetRotAngleBtn, gridBagConstraints);
        this.backBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.backBtn, gridBagConstraints);
        this.readButtonHintsFromPreferenceFile();
    }
}

