/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.buttons;

import ice.Controller;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.gui.panel.sans.actions.PauseAutoCollectionAction;
import ice.swing.buttons.KeyResponseButton;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class PauseButton
extends KeyResponseButton
implements InstrumentValueChangedListener {
    public static final String pause = "F11: Pause Auto Collection";
    public static final String resume = "F11: Resume Auto Collection";

    public PauseButton(String text, String actionCommand, int key) {
        super(text, actionCommand, key);
    }

    @Override
    protected void init(String actionCommand, AbstractAction action, int key) {
        super.init(actionCommand, action, key);
        Controller controller = Controller.getReference();
        Instrument instrument = controller.getInstrument();
        try {
            instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("PauseButton.init " + e);
        }
        PauseAutoCollectionAction pauseAction = new PauseAutoCollectionAction();
        this.addActionListener(pauseAction);
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent evt) {
        if (evt.getSource() instanceof Instrument) {
            Instrument instrument = (Instrument)evt.getSource();
            String propertyName = evt.getPropertyName();
            if ("state".equals(propertyName)) {
                Instrument.State newState = (Instrument.State)((Object)evt.getNewValue());
                Instrument.State oldState = (Instrument.State)((Object)evt.getNewValue());
                boolean enabled = this.isEnabled();
                if (enabled) {
                    switch (newState) {
                        case pause: {
                            this.setText(resume);
                            break;
                        }
                        default: {
                            this.setText(pause);
                            break;
                        }
                    }
                } else {
                    this.setText(pause);
                }
            }
        }
    }
}

