/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.buttons;

import ice.gui.core.GenericIcePanel;
import ice.gui.panel.sans.actions.MoveDeviceAction;
import ice.gui.panel.sans.controls.SansButtonPanelControl;
import ice.gui.panel.sans.controls.SansDeviceControlNoScalePanel;
import ice.gui.panel.sans.controls.buttons.F20PreviousMenuButton;
import ice.gui.panel.sans.subpanels.DetectorPanel;
import ice.swing.buttons.KeyResponseButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;

public class DetectorButtonControlPanel
extends SansButtonPanelControl {
    private static final String moveDetDist = "F17: Move to Target Distance";
    private static final String moveDetOff = "F18: Move to Target Offset";
    private static final String back = "F20: Previous Menu";
    private F20PreviousMenuButton backBtn;
    private KeyResponseButton moveDetDistanceBtn;
    private KeyResponseButton moveDetOffsetBtn;
    private ActionListener[] oldActions;
    private DetectorPanel detectorPanel;

    public DetectorButtonControlPanel(GenericIcePanel parentPanel) {
        super(parentPanel);
    }

    @Override
    protected void init(GenericIcePanel panel) {
        super.init(panel);
        this.detectorPanel = (DetectorPanel)panel;
        this.moveDetDistanceBtn = new KeyResponseButton(moveDetDist, moveDetDist, 120);
        this.moveDetDistanceBtn.setEnabled(false);
        this.moveDetOffsetBtn = new KeyResponseButton(moveDetOff, moveDetOff, 121);
        this.moveDetOffsetBtn.setEnabled(false);
        this.backBtn = new F20PreviousMenuButton();
    }

    public void enableMoveDetDistanceBtn(final boolean enable) {
        this.moveDetDistanceBtn.getActionListeners();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectorButtonControlPanel.this.moveDetDistanceBtn.setEnabled(enable);
            }
        });
    }

    public void enableMoveDetOffsetBtn(final boolean enable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectorButtonControlPanel.this.moveDetOffsetBtn.setEnabled(enable);
            }
        });
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SansDeviceControlNoScalePanel detDistanceControl = this.detectorPanel.getDetDistanceControl();
        SansDeviceControlNoScalePanel detOffsetControl = this.detectorPanel.getDetOffsetControl();
        MoveDeviceAction moveDetDistAction = new MoveDeviceAction(detDistanceControl);
        this.moveDetDistanceBtn.addActionListener(moveDetDistAction);
        this.addToClearsErrors(this.moveDetDistanceBtn);
        this.moveDetDistanceBtn.addActionListener(this);
        this.moveDetDistanceBtn.setHorizontalAlignment(2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.moveDetDistanceBtn, gridBagConstraints);
        MoveDeviceAction moveDetOffAction = new MoveDeviceAction(detOffsetControl);
        this.moveDetOffsetBtn.addActionListener(moveDetOffAction);
        this.addToClearsErrors(this.moveDetOffsetBtn);
        this.moveDetOffsetBtn.addActionListener(this);
        this.moveDetOffsetBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.moveDetOffsetBtn, gridBagConstraints);
        this.backBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.backBtn, gridBagConstraints);
        this.readButtonHintsFromPreferenceFile();
    }
}

