/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.ClientAPI;
import ice.commands.DeviceComponentsCommand;
import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.gui.panel.sans.communication.FixDeviceActionListener;
import ice.gui.panel.sans.controls.JSansCheckBox;
import ice.gui.panel.sans.controls.SansDeviceWithScaleControlPanel;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SansDeviceComboBoxWithScaleControlPanel
extends SansDeviceWithScaleControlPanel {
    private static final long serialVersionUID = -6444196924841530235L;
    private JLabel currentLabel;
    protected JTextField currentField;
    private JLabel targetLabel;
    protected JComboBox targetComboBox;
    protected DefaultComboBoxModel targetBoxModel;
    private JCheckBox fixedBox;
    private JLabel deviceLabel;
    private JLabel unitCurrentLabel;
    private JLabel unitTargetLabel;
    protected JTextField currentScaleField;
    protected JTextField targetScaleField;
    protected GridBagConstraints gridBagConstraints;

    public SansDeviceComboBoxWithScaleControlPanel(String name, String deviceName, String scaleDeviceName, String scaleUnits) {
        super(name, deviceName, scaleDeviceName, scaleUnits);
    }

    public void listenToTargetComboBoxActions(ActionListener l) {
        this.targetComboBox.addActionListener(l);
    }

    @Override
    protected JTextField instantiateCurrentField() {
        return new JTextField();
    }

    protected JTextField instantiateCurrentScaleField() {
        return new JTextField();
    }

    protected JTextField instantiateTargetScaleField() {
        return new JTextField();
    }

    public void addTargetItem(String item) {
        this.targetComboBox.addItem(item);
    }

    public void removeTargetItem(String item) {
        this.targetComboBox.removeItem(item);
    }

    @Override
    protected void init() {
        super.init();
        this.currentLabel = new JLabel();
        this.currentField = this.instantiateCurrentField();
        this.targetLabel = new JLabel();
        this.targetComboBox = new JComboBox();
        this.targetComboBox.addActionListener(new TargetComboBoxActionListener());
        this.fixedBox = new JSansCheckBox();
        this.deviceLabel = new JLabel();
        this.unitCurrentLabel = new JLabel();
        this.unitTargetLabel = new JLabel();
        this.fixedBox.addActionListener(new FixDeviceActionListener(this));
        this.targetBoxModel = new DefaultComboBoxModel();
        this.targetBoxModel.addElement("");
        this.targetComboBox.setModel(this.targetBoxModel);
        this.currentScaleField = this.instantiateCurrentScaleField();
        this.targetScaleField = this.instantiateTargetScaleField();
        this.targetComboBox.addFocusListener(new SansInputControlFocusListener());
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.deviceLabel.setText(this.controlName);
        this.deviceLabel.setPreferredSize(new Dimension(140, 20));
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.anchor = 18;
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.gridBagConstraints.gridwidth = 2;
        this.add((Component)this.deviceLabel, this.gridBagConstraints);
        this.currentLabel.setText("Current");
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.currentLabel, this.gridBagConstraints);
        this.currentField.setEditable(false);
        this.currentField.setText("");
        this.currentField.setPreferredSize(new Dimension(60, 20));
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.currentField, this.gridBagConstraints);
        this.currentScaleField.setEditable(false);
        this.currentScaleField.setText("");
        this.gridBagConstraints.gridx = 2;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.gridBagConstraints.fill = 2;
        this.add((Component)this.currentScaleField, this.gridBagConstraints);
        this.gridBagConstraints.fill = 0;
        if (this.showFixed) {
            this.fixedBox.setText("Fixed");
            this.fixedBox.addActionListener(new FixDeviceActionListener(this));
            this.gridBagConstraints.anchor = 13;
            this.gridBagConstraints.gridx = 3;
            this.gridBagConstraints.gridy = 0;
            this.gridBagConstraints.fill = 0;
            this.gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)this.fixedBox, this.gridBagConstraints);
        }
        this.gridBagConstraints.anchor = 17;
        this.targetLabel.setText("Target");
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.targetLabel, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.gridBagConstraints.fill = 2;
        this.add((Component)this.targetComboBox, this.gridBagConstraints);
        this.gridBagConstraints.fill = 0;
        this.targetScaleField.setPreferredSize(new Dimension(60, 20));
        this.targetScaleField.setEditable(false);
        this.gridBagConstraints.gridx = 2;
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.targetScaleField, this.gridBagConstraints);
        this.unitCurrentLabel.setText(this.units);
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.gridx = 3;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.unitCurrentLabel, this.gridBagConstraints);
        this.unitTargetLabel.setText(this.units);
        this.gridBagConstraints.gridx = 3;
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.unitTargetLabel, this.gridBagConstraints);
    }

    @Override
    public String getCurrentValue() {
        return this.currentField.getText();
    }

    @Override
    public void setCurrentValue(String value) {
        this.currentField.setText(value);
    }

    public JLabel getDeviceLabel() {
        return this.deviceLabel;
    }

    @Override
    public String getTargetValue() {
        String targetValue = (String)this.targetComboBox.getSelectedItem();
        return targetValue;
    }

    @Override
    public void setTargetValue(String value) {
        this.targetBoxModel.setSelectedItem(value);
    }

    public void addItem(String item) {
        this.targetBoxModel.addElement(item);
    }

    public void addItems(String[] items) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.targetBoxModel.addElement(item);
            ++n2;
        }
    }

    @Override
    public void setCurrentTranslationValue(String currentValue) {
        this.currentScaleField.setText(currentValue);
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        String currentValue;
        super.actionPerformed(evt);
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        String name = changedDevice.getName();
        if (changedDevice.getName().equalsIgnoreCase(this.deviceName) && evt.getPropertyName().equalsIgnoreCase("currValue")) {
            currentValue = changedDevice.getCurrValue();
            this.setCurrentValue(currentValue);
        }
        if (changedDevice.getName().equalsIgnoreCase(this.scaleDeviceName) && evt.getPropertyName().equalsIgnoreCase("currValue")) {
            currentValue = changedDevice.getCurrValue();
            this.setCurrentTranslationValue(currentValue);
        }
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent evt) {
        super.actionPerformed(evt);
    }

    public void performComboBoxAction() {
        String value = (String)this.targetBoxModel.getSelectedItem();
        String scale = "";
        if (value.equals("")) {
            this.targetScaleField.setText(scale);
            return;
        }
        String[] targetValues = this.getTargetTranslation(value);
        if (targetValues == null || targetValues.length < 2) {
            this.targetScaleField.setText(scale);
            return;
        }
        int i = 0;
        while (i < targetValues.length) {
            if (this.scaleDeviceName.equals(targetValues[i])) {
                scale = targetValues[i + 1];
                break;
            }
            ++i;
        }
        this.targetScaleField.setText(scale);
    }

    public String[] getTargetTranslation(String value) {
        String command = String.valueOf(this.deviceName) + " " + value;
        String[] values = new String[]{"N/A"};
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            DeviceComponentsCommand iCommand = new DeviceComponentsCommand(command, messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
        }
        catch (Exception e) {
            this.logger.error("Error while executing a command...", e);
        }
        return values;
    }

    @Override
    public void clearTargetValue() {
        this.targetBoxModel.setSelectedItem("");
        this.targetScaleField.setText("");
    }

    @Override
    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        this.fixedBox.setSelected(fixed);
    }

    private class TargetComboBoxActionListener
    implements ActionListener {
        private TargetComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SansDeviceComboBoxWithScaleControlPanel.this.performComboBoxAction();
        }
    }
}

