/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.subpanels.CollimationPanel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;

public class CollimationControl
implements DeviceValueChangedListener {
    private SansDeviceControlPanel apertureControl;

    public CollimationControl(SansDeviceControlPanel apertureControl) {
        this.apertureControl = apertureControl;
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice("GuideTable");
        if (device != null) {
            this.configureApertureControl(device.getCurrValue());
            try {
                device.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent event) {
        if (event.getPropertyName().equalsIgnoreCase("currValue")) {
            InstalledDevice changedDevice = (InstalledDevice)event.getSource();
            String currentValue = changedDevice.getCurrValue();
            this.configureApertureControl(currentValue);
        }
    }

    private void configureApertureControl(String guideState) {
        boolean ng3guide07state = CollimationPanel.determineGuideState("ng3", "7", guideState);
        if (guideState.equals("POLBEAM") || ng3guide07state) {
            this.apertureControl.removeFromDeviceValueChangeListenerList();
            this.apertureControl.addToDeviceValueChangeListenerList("Guide08");
        } else {
            this.apertureControl.removeFromDeviceValueChangeListenerList();
            this.apertureControl.addToDeviceValueChangeListenerList("Guide01");
        }
    }
}

