/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.Controller;
import ice.data.tas.bt7.Instrument;
import ice.gui.core.IceDialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class ChangeExperimentIDDialog
extends IceDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 3373417983269660876L;
    private String input = null;
    private JComboBox inputComboBox;
    private JOptionPane optionPane;
    private static final String btnEnterString = "Enter";
    private static final String btnCancelString = "Cancel";
    private static final String messageString = "Please select new Experiment ID from the drop down box below";
    private static final String titleString = "Change Experiment";
    private static final String sansString = "SANS";

    public ChangeExperimentIDDialog() {
        this.setModal(true);
        this.setTitle(titleString);
        this.inputComboBox = new JComboBox();
        Controller controller = Controller.getReference();
        Instrument instrument = controller.getInstrument();
        String expName = String.valueOf(instrument.getName().toUpperCase()) + sansString;
        int i = 0;
        while (i <= 50) {
            this.inputComboBox.addItem(String.valueOf(expName) + i);
            ++i;
        }
        Object[] array = new Object[]{messageString, this.inputComboBox};
        Object[] options = new Object[]{btnEnterString, btnCancelString};
        this.optionPane = new JOptionPane(array, -1, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ChangeExperimentIDDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.optionPane.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        this.input = null;
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (btnEnterString.equals(value)) {
                this.input = (String)this.inputComboBox.getSelectedItem();
                this.setVisible(false);
            } else {
                this.setVisible(false);
            }
        }
    }

    @Override
    public String getUserSelection() {
        if (this.input == null) {
            return null;
        }
        return this.input.toString();
    }
}

