/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.actions;

import ice.ClientAPI;
import ice.IcePanelManager;
import ice.commands.ImmediateCommand;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceWindow;
import ice.gui.core.controls.serverFileView.ServerFileSaveDialog;
import ice.gui.core.controls.serverFileView.ServerFolderView;
import ice.gui.panel.sans.DataAcquisitionPanel;
import ice.gui.panel.sans.actions.SansButtonAction;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class SaveRunConfigAction
extends SansButtonAction {
    private static Logger logger = Logger.getLogger("ErrorLogger.AutoRunKeyStrokeAction");
    private JTable table;

    public SaveRunConfigAction(String name, int keyStroke, JTable table) {
        super(name, keyStroke);
        this.table = table;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        IcePanelManager panelManager = IcePanelManager.getReference();
        GenericIcePanel panel = panelManager.findOpenPanelByName(DataAcquisitionPanel.title);
        IceWindow window = panelManager.getIceWindow(panel);
        String parentName = "";
        IceFile parentDir = null;
        int selection = this.table.getSelectedRow();
        if (selection == -1) {
            logger.error("User attempted to save scan while nothing was selected.");
            return;
        }
        ServerFileSaveDialog.FileNameAndParent fileNameAndParent = ServerFileSaveDialog.saveIceFileToServer(window, IceFileType.sansConfig, ServerFolderView.ValidServerFolders.USER, true);
        if (fileNameAndParent == null) {
            return;
        }
        parentDir = fileNameAndParent.getParent();
        if (parentDir != null && parentDir.isMagicWord()) {
            parentName = String.valueOf(parentDir.getName()) + ":";
        }
        String message = "Scan SaveConfigID " + parentName + fileNameAndParent.getFileName() + " " + (selection + 1);
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            ImmediateCommand command = new ImmediateCommand(message, messageSender);
            command.runAsynchronous();
        }
        catch (Exception e) {
            logger.error("client api error", e.getCause());
        }
    }
}

