/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.actions;

import ice.ClientAPI;
import ice.commands.QueuedCommand;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.composite.SansDevicePropertyControl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class SansMoveDeviceAction
implements ActionListener {
    private static Logger logger = Logger.getLogger("ErrorLogger");
    SansDevicePropertyControl deviceProperty;

    public SansMoveDeviceAction(SansDevicePropertyControl prop) {
        this.deviceProperty = prop;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.executeCommand(this.deviceProperty);
    }

    private void executeCommand(SansDeviceControlPanel devicePanel) {
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            String value = devicePanel.getTargetValue();
            String trimmedValue = value.trim();
            if (trimmedValue.equals("")) {
                return;
            }
            String deviceName = devicePanel.getDeviceName();
            devicePanel.clearTargetValue();
            QueuedCommand command = new QueuedCommand("move " + deviceName + " " + value, messageSender);
            command.runAsynchronous();
        }
        catch (Exception e) {
            logger.error("client api error", e.getCause());
        }
    }
}

