/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.Controller;
import ice.Global;
import ice.communication.CommunicationManager;
import ice.data.Experiment;
import ice.data.Queue;
import ice.data.tas.bt7.Instrument;
import ice.event.QueueChangedEvent;
import ice.event.QueueChangedListener;
import ice.event.SendEvent;
import ice.event.SendListener;
import ice.event.communication.BroadcastMessageEvent;
import ice.event.communication.BroadcastMessageListener;
import ice.event.communication.ClientMessageEvent;
import ice.event.communication.ClientMessageListener;
import ice.event.communication.ErrorMessageEvent;
import ice.event.communication.ErrorMessageListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.event.communication.StatusChangeEvent;
import ice.event.communication.StatusChangeListener;
import ice.event.request.LoadPanelReqListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceViewPanel;
import ice.swing.Bag;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.PreferencesManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ConsolePanel
extends IceViewPanel
implements ClientMessageListener,
ActionListener,
PropertyChangeListener,
InstrumentValueChangedListener,
ChangeListener,
BroadcastMessageListener,
SendListener,
ErrorMessageListener,
StatusChangeListener,
QueueChangedListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.ConsoleLogger");
    private static Logger userLogger = Logger.getLogger("UserConsoleLogger");
    private static Logger dryRunLogger = Logger.getLogger("UserDryRunLogger");
    private static Logger errorLogger = Logger.getLogger("UserErrorLogger");
    private Queue queue;
    private String experimentNumber;
    private String experimentName;
    private Date instrumentTime;
    private DateFormat lineDateFormat;
    private DateFormat instDateFormat;
    private String instrumentName;
    private String instrumentStatus;
    private String currOperation;
    private String operationOwner;
    private long currPoint;
    private long totalPoints;
    private double monitorCount;
    private double detectorCount;
    private final int ARRAYSIZE = 15;
    private ArrayList<String> cmdHistory;
    private int historyPosition;
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private Pattern fontPattern;
    private JiceEditorPane logEditorPane;
    private JScrollPane logEditorScrollPane;
    private JiceEditorPane dryRunEditorPane;
    private JScrollPane dryRunEditorScrollPane;
    private JiceEditorPane errorEditorPane;
    private JTextField inputTextField;
    private JLabel currExperimentLabel;
    private JLabel instrumentTimeLabel;
    private JLabel currStatusLabel;
    private JLabel currOperationLabel;
    private JLabel monitorCountLabel1;
    private JLabel monitorCountLabel2;
    private JLabel detectorCountLabel1;
    private JLabel detectorCountLabel2;
    private JLabel scanProgressLabel;
    private JProgressBar progressBar;
    private JPanel statusBar;
    private JLabel connectionStatusLabel;
    private ArrayList<LoadPanelReqListener> panelRequestListeners;
    private static ConsolePanel reference = null;
    private Controller controller;
    public static final String defaultTimeZoneString = "defaultTimeZone";
    public static final String defaultTimeZoneValue = "America/New_York";
    private static final String unknownString = "Unknown";

    public ConsolePanel() throws IcePanelException {
        super("Console");
    }

    @Override
    protected void init() {
        this.controller = Controller.getReference();
        this.queue = this.controller.getServerQueue();
        this.panelRequestListeners = new ArrayList();
        this.experimentNumber = unknownString;
        this.experimentName = unknownString;
        this.instrumentName = unknownString;
        this.instrumentStatus = unknownString;
        this.currOperation = unknownString;
        this.operationOwner = unknownString;
        this.instrumentTime = new Date();
        this.lineDateFormat = DateFormat.getTimeInstance(2);
        String timeZone = PreferencesManager.getPreferenceString(defaultTimeZoneString, defaultTimeZoneValue);
        this.lineDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        this.instDateFormat = DateFormat.getDateTimeInstance(2, 0);
        this.instDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        this.cmdHistory = new ArrayList(15);
        this.cmdHistory.add(0, "");
        this.historyPosition = 0;
        this.fontPattern = Pattern.compile("color=\"#......\"");
        Queue queue = this.controller.getServerQueue();
        ArrayList<ChangeListener> changeListeners = this.controller.getExpChangeListeners();
        changeListeners.add(this);
        CommunicationManager comManager = this.controller.getCommMgr();
        try {
            queue.addChangeListener(this);
            comManager.addClientListener(this);
            comManager.addMessageListener(this);
            comManager.addSendListener(this);
            comManager.addErrorListener(this);
            comManager.addStatusListener(this);
            Instrument instrument = this.controller.getInstrument();
            instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("Could not add listener " + e);
        }
        Experiment experiment = this.controller.getExperiment();
        this.experimentName = experiment.getName();
        this.experimentNumber = experiment.getID();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints mainConstraints = new GridBagConstraints();
        mainConstraints.gridx = 0;
        mainConstraints.gridy = 0;
        mainConstraints.fill = 1;
        mainConstraints.weightx = 1.0;
        mainConstraints.weighty = 1.0;
        mainConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel statusPanel = this.createStatusPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(200, 200));
        this.tabbedPane.setMinimumSize(new Dimension(20, 20));
        this.logEditorPane = new JiceEditorPane();
        this.logEditorPane.setEditable(false);
        this.logEditorPane.setFont(new Font("Courier New", 0, 12));
        this.logEditorScrollPane = new JScrollPane(this.logEditorPane, 22, 31);
        this.logEditorScrollPane.setPreferredSize(new Dimension(200, 100));
        this.logEditorScrollPane.setMinimumSize(new Dimension(20, 20));
        this.dryRunEditorPane = new JiceEditorPane();
        this.dryRunEditorPane.setEditable(false);
        this.dryRunEditorPane.setFont(new Font("Courier New", 0, 12));
        this.dryRunEditorScrollPane = new JScrollPane(this.dryRunEditorPane);
        this.dryRunEditorScrollPane.setVerticalScrollBarPolicy(22);
        this.dryRunEditorScrollPane.setPreferredSize(new Dimension(200, 100));
        this.dryRunEditorScrollPane.setMinimumSize(new Dimension(20, 20));
        this.errorEditorPane = new JiceEditorPane();
        this.errorEditorPane.setEditable(false);
        this.errorEditorPane.setFont(new Font("Courier New", 0, 12));
        JScrollPane errorEditorScrollPane = new JScrollPane(this.errorEditorPane);
        errorEditorScrollPane.setVerticalScrollBarPolicy(22);
        errorEditorScrollPane.setPreferredSize(new Dimension(200, 100));
        errorEditorScrollPane.setMinimumSize(new Dimension(20, 20));
        this.tabbedPane.add("<html><font color=\"#000000\">Log Messages</font></hmtl>", this.logEditorScrollPane);
        this.tabbedPane.add("<html><font color=\"#000000\">Dry Run Results</font></hmtl>", this.dryRunEditorScrollPane);
        this.tabbedPane.add("<html><font color=\"#000000\">Detailed Error Messages</font></hmtl>", errorEditorScrollPane);
        this.tabbedPane.addChangeListener(this);
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints inputConstraints = new GridBagConstraints();
        inputConstraints.gridx = 0;
        inputConstraints.gridy = 0;
        inputConstraints.fill = 2;
        inputConstraints.weightx = 0.0;
        inputConstraints.insets = new Insets(0, 5, 0, 5);
        JLabel inputLabel = new JLabel("Input: ");
        this.inputTextField = new JTextField(10);
        this.inputTextField.requestFocusInWindow();
        this.inputTextField.setName("consoleInputText");
        this.inputTextField.addActionListener(this);
        this.listenToInputText(this.controller);
        AbstractAction backCmd = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConsolePanel.this.cmdHistory.isEmpty()) {
                    return;
                }
                if (ConsolePanel.this.cmdHistory.size() <= ConsolePanel.this.historyPosition + 1) {
                    ConsolePanel.this.historyPosition = 0;
                } else {
                    ConsolePanel consolePanel = ConsolePanel.this;
                    consolePanel.historyPosition = consolePanel.historyPosition + 1;
                }
                ConsolePanel.this.inputTextField.setText((String)ConsolePanel.this.cmdHistory.get(ConsolePanel.this.historyPosition));
            }
        };
        AbstractAction forwardCmd = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConsolePanel.this.cmdHistory.isEmpty()) {
                    return;
                }
                if (ConsolePanel.this.historyPosition > 0) {
                    ConsolePanel consolePanel = ConsolePanel.this;
                    consolePanel.historyPosition = consolePanel.historyPosition - 1;
                    ConsolePanel.this.inputTextField.setText((String)ConsolePanel.this.cmdHistory.get(ConsolePanel.this.historyPosition));
                }
            }
        };
        this.inputTextField.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "up");
        this.inputTextField.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "down");
        this.inputTextField.getActionMap().put("up", backCmd);
        this.inputTextField.getActionMap().put("down", forwardCmd);
        inputPanel.add((Component)inputLabel, inputConstraints);
        ++inputConstraints.gridx;
        inputConstraints.weightx = 1.0;
        inputPanel.add((Component)this.inputTextField, inputConstraints);
        mainConstraints.weighty = 0.0;
        this.mainPanel.add((Component)statusPanel, mainConstraints);
        ++mainConstraints.gridy;
        mainConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.tabbedPane, mainConstraints);
        ++mainConstraints.gridy;
        mainConstraints.weighty = 0.0;
        this.mainPanel.add((Component)inputPanel, mainConstraints);
        this.add((Component)this.mainPanel, "Center");
        this.buildStatusBar();
    }

    private void buildStatusBar() {
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new BoxLayout(this.statusBar, 3));
        this.statusBar.setBorder(new BevelBorder(1));
        this.connectionStatusLabel = new JLabel(" Connected to " + Global.getInstrumentName() + ".");
        this.statusBar.add(this.connectionStatusLabel);
    }

    private JPanel createStatusPanel() {
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.setBorder(BorderFactory.createTitledBorder("Instrument Status"));
        Bag statusConstraints = new Bag();
        statusConstraints.inset(5, 5, 5, 5);
        JPanel row1 = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        constraints.inset(0, 5, 0, 5);
        int x = 0;
        int y = 0;
        this.currStatusLabel = new JLabel("Instrument Status: " + this.instrumentName + " is " + this.instrumentStatus);
        JLabel emptyLabel = new JLabel("");
        String time = this.instDateFormat.format(this.instrumentTime);
        this.instrumentTimeLabel = new JLabel("<html><b>Instrument Time: </b>" + time + "</html>");
        row1.add((Component)this.currStatusLabel, constraints.cell(x, y));
        row1.add((Component)emptyLabel, constraints.cell(++x, y).fillx());
        row1.add((Component)this.instrumentTimeLabel, constraints.cell(++x, y));
        JPanel row2 = new JPanel(new GridBagLayout());
        int x2 = 0;
        int y2 = 0;
        this.currExperimentLabel = new JLabel("<html><b>Current Experiment:</b> " + this.experimentNumber + " - " + this.experimentName + "</html>");
        row2.add((Component)this.currExperimentLabel, constraints.cell(x2, y2).fillx());
        JPanel row3 = new JPanel(new GridBagLayout());
        int x3 = 0;
        int y3 = 0;
        this.currOperationLabel = new JLabel("Current Operation: " + this.currOperation + " (run by " + this.operationOwner + ")");
        row3.add((Component)this.currOperationLabel, constraints.cell(x3, y3).fillx());
        JPanel row4 = new JPanel(new GridBagLayout());
        int x4 = 0;
        int y4 = 0;
        JPanel progressPanel = this.createProgressPanel();
        JPanel pointPanel = this.createPointPanel();
        row4.add((Component)progressPanel, constraints.cell(x4, y4).fillx());
        ++x4;
        x4 = 0;
        y4 = 0;
        statusPanel.add((Component)row1, statusConstraints.cell(x4, y4).fillx());
        statusPanel.add((Component)row2, statusConstraints.cell(x4, ++y4).fillx());
        statusPanel.add((Component)row3, statusConstraints.cell(x4, ++y4).fillx());
        statusPanel.add((Component)row4, statusConstraints.cell(x4, ++y4).fillx());
        return statusPanel;
    }

    private JPanel createProgressPanel() {
        this.scanProgressLabel = new JLabel("Scan Progress: " + this.currPoint + " of " + this.totalPoints, 0);
        this.progressBar = new JProgressBar(0, 100);
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        constraints.inset(0, 0, 0, 0);
        int x = 0;
        int y = 0;
        panel.add((Component)this.scanProgressLabel, constraints.cell(x, y).fillx());
        panel.add((Component)this.progressBar, constraints.cell(x, ++y).fillx());
        return panel;
    }

    private JPanel createPointPanel() {
        this.monitorCountLabel1 = new JLabel("<html><b>Monitor Count:</b> ");
        this.monitorCountLabel2 = new JLabel(String.valueOf(this.monitorCount));
        this.detectorCountLabel1 = new JLabel("<html><b>Detector Count:</b> ");
        this.detectorCountLabel2 = new JLabel(String.valueOf(this.detectorCount));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        panel.add((Component)this.monitorCountLabel1, constraints.cell(x, y));
        panel.add((Component)this.monitorCountLabel2, constraints.cell(++x, y));
        panel.add((Component)this.detectorCountLabel1, constraints.cell(--x, ++y));
        panel.add((Component)this.detectorCountLabel2, constraints.cell(++x, y));
        return panel;
    }

    public void addLoadPanelReqListener(LoadPanelReqListener lprl) {
        this.panelRequestListeners.add(lprl);
    }

    public void removeLoadPanelReqListener(LoadPanelReqListener lprl) {
        this.panelRequestListeners.remove(lprl);
    }

    public void listenToInputText(ActionListener listener) {
        this.inputTextField.addActionListener(listener);
    }

    public void clearTextField() {
        this.inputTextField.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String componentName = ((JComponent)ae.getSource()).getName();
        if (componentName.equalsIgnoreCase("consoleInputText")) {
            JTextField inputTextField = (JTextField)ae.getSource();
            String cmd = inputTextField.getText();
            this.addToHistory(cmd);
            this.clearTextField();
        }
    }

    public void addToHistory(String newCmd) {
        int size = this.cmdHistory.size();
        if (size >= 15) {
            this.cmdHistory.remove(14);
        }
        this.cmdHistory.add(1, newCmd);
        this.historyPosition = 0;
    }

    @Override
    public void actionPerformed(ClientMessageEvent ce) {
        String data = ce.getData();
        StringTokenizer tokenizer = new StringTokenizer(data, ":");
        if (!tokenizer.hasMoreTokens()) {
            SwingUtilities.invokeLater(new UpdateLogRunnable(this.logEditorPane, data, userLogger));
        } else {
            String firstToken = tokenizer.nextToken();
            if (firstToken.equalsIgnoreCase("Dry run scan")) {
                SwingUtilities.invokeLater(new UpdateLogRunnable(this.dryRunEditorPane, data, dryRunLogger));
            } else if (firstToken.equalsIgnoreCase("Error")) {
                SwingUtilities.invokeLater(new UpdateLogRunnable(this.errorEditorPane, data, errorLogger));
            } else {
                SwingUtilities.invokeLater(new UpdateLogRunnable(this.logEditorPane, data, userLogger));
            }
        }
    }

    @Override
    public synchronized void actionPerformed(InstrumentValueChangedEvent pce) {
        Instrument instrument = (Instrument)pce.getSource();
        String propertyName = pce.getPropertyName();
        if (propertyName.equals("state")) {
            this.instrumentStatus = instrument.getState().toString();
        } else if (propertyName.equals("name")) {
            this.instrumentName = instrument.getName();
        } else if (propertyName.equals("time")) {
            this.instrumentTime = instrument.getTime();
        } else if (propertyName.equals("currScanPnt")) {
            this.currPoint = instrument.getCurrScanPnt();
        } else if (propertyName.equals("totalScanPnts")) {
            this.totalPoints = instrument.getTotalScanPnts();
        }
        this.updateInfoPanel();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource() instanceof Experiment) {
            Experiment experiment = (Experiment)pce.getSource();
            this.experimentNumber = experiment.getID() == null ? unknownString : experiment.getID();
            this.experimentName = experiment.getName() == null ? unknownString : experiment.getName();
        } else {
            logger.debug("no match");
        }
        this.updateInfoPanel();
    }

    @Override
    public void actionPerformed(QueueChangedEvent event) {
        Queue theQueue = (Queue)event.getSource();
        this.operationOwner = theQueue.getCurrOwner() == null ? unknownString : theQueue.getCurrOwner();
        this.currOperation = theQueue.getCurrCommand() == null ? unknownString : theQueue.getCurrCommand().getCommandString();
        this.updateInfoPanel();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Object source = ce.getSource();
        if (source instanceof Experiment) {
            Experiment experiment = (Experiment)ce.getSource();
            this.experimentNumber = experiment.getID() == null ? unknownString : experiment.getID();
            this.experimentName = experiment.getName() == null ? unknownString : experiment.getName();
            this.updateInfoPanel();
        } else if (source == this.tabbedPane) {
            int selectedIndex = this.tabbedPane.getSelectedIndex();
            String title = this.tabbedPane.getTitleAt(selectedIndex);
            Matcher fontMatcher = this.fontPattern.matcher(title);
            String newTitle = fontMatcher.replaceFirst("color=\"#000000\"");
            this.tabbedPane.setTitleAt(selectedIndex, newTitle);
        } else {
            logger.debug("no match");
        }
    }

    private void updateInfoPanel() {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.currExperimentLabel.setText("<html><b>Current Experiment:</b> " + ConsolePanel.this.experimentNumber + " - " + ConsolePanel.this.experimentName + "</html>");
                ConsolePanel.this.currStatusLabel.setText("<html><b>Instrument Status:</b> " + ConsolePanel.this.instrumentName + " is " + ConsolePanel.this.instrumentStatus + "</html>");
                ConsolePanel.this.currOperationLabel.setText("<html><b>Current Operation:</b> " + ConsolePanel.this.currOperation + " (run by " + ConsolePanel.this.operationOwner + ")</html>");
                String time = ConsolePanel.this.instDateFormat.format(ConsolePanel.this.instrumentTime);
                ConsolePanel.this.instrumentTimeLabel.setText("<html><b>Instrument Time:</b> " + time + "</html>");
            }
        };
        SwingUtilities.invokeLater(update);
    }

    @Override
    public void actionPerformed(BroadcastMessageEvent me) {
        String message = me.getData();
        try {
            this.actionPerformed(new ClientMessageEvent(this, message));
        }
        catch (Exception e) {
            logger.error("ConsolePanel.newMessage " + e);
        }
    }

    @Override
    public void actionPerformed(SendEvent se) {
        SwingUtilities.invokeLater(new UpdateLogRunnable(this.logEditorPane, se.getMessage(), userLogger));
    }

    @Override
    public void actionPerformed(ErrorMessageEvent ee) {
        SwingUtilities.invokeLater(new UpdateLogRunnable(this.errorEditorPane, ee.getMessage(), userLogger));
    }

    @Override
    public synchronized void statusChanged(StatusChangeEvent sce) {
        Float scanProgress = sce.getScanProgress();
        Integer currentScanPoint = sce.getScanPoint();
        Integer totalScanPoints = sce.getTotalScanPoints();
        float value = 0.0f;
        if (scanProgress != null) {
            value = scanProgress.floatValue();
        }
        String message = "Scan Progress: ";
        message = currentScanPoint == null || totalScanPoints == null || currentScanPoint.equals(-1) ? String.valueOf(message) + "No scan running." : String.valueOf(message) + currentScanPoint + " of " + totalScanPoints;
        this.updateProgressBar(value, message);
    }

    private synchronized void updateProgressBar(float percentage, String message) {
        int value = 0;
        int progressBarMax = Integer.MAX_VALUE;
        final String text = message;
        if (this.progressBar != null) {
            float theValue = 0.0f;
            progressBarMax = this.progressBar.getMaximum();
            theValue = percentage * (float)progressBarMax;
            value = Float.valueOf(theValue).intValue();
        }
        final int endValue = value;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public synchronized void run() {
                ConsolePanel.this.scanProgressLabel.setText(text);
                ConsolePanel.this.progressBar.setValue(endValue);
            }
        });
    }

    @Override
    protected void updateLockState() {
        SwingUtilities.invokeLater(new LockToggleRunnable(this.locked));
    }

    @Override
    public boolean requestFocusInIceWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.inputTextField.requestFocusInWindow();
            }
        });
        return true;
    }

    private class JiceEditorPane
    extends JEditorPane {
        private int numEntries = 0;
        private String[] buffer = new String[1000];
        private final int BUFFERSIZE = 1000;

        public void addLine(String text) {
            int newEntry = this.numEntries++ % 1000;
            this.buffer[newEntry] = text;
            StringBuffer sb = new StringBuffer();
            int place = 0;
            if (this.numEntries > 1000) {
                place = newEntry + 1;
            }
            int lastEntry = this.numEntries < 1000 ? this.numEntries : 1000;
            int i = 0;
            while (i < lastEntry) {
                if (place == 1000) {
                    place = 0;
                }
                sb.append(String.valueOf(this.buffer[place++]) + '\n');
                ++i;
            }
            super.setText(sb.toString());
        }
    }

    private class LockToggleRunnable
    implements Runnable {
        private boolean locked;

        LockToggleRunnable(boolean locked) {
            this.locked = locked;
        }

        @Override
        public void run() {
            if (this.locked) {
                ConsolePanel.this.inputTextField.setEnabled(false);
                ConsolePanel.this.progressBar.setEnabled(false);
                ConsolePanel.this.currExperimentLabel.setForeground(Color.GRAY);
                ConsolePanel.this.instrumentTimeLabel.setForeground(Color.GRAY);
                ConsolePanel.this.currStatusLabel.setForeground(Color.GRAY);
                ConsolePanel.this.currOperationLabel.setForeground(Color.GRAY);
                ConsolePanel.this.monitorCountLabel1.setForeground(Color.GRAY);
                ConsolePanel.this.monitorCountLabel2.setForeground(Color.GRAY);
                ConsolePanel.this.detectorCountLabel1.setForeground(Color.GRAY);
                ConsolePanel.this.detectorCountLabel2.setForeground(Color.GRAY);
            } else {
                ConsolePanel.this.inputTextField.setEnabled(true);
                ConsolePanel.this.progressBar.setEnabled(true);
                ConsolePanel.this.currExperimentLabel.setForeground(Color.BLACK);
                ConsolePanel.this.instrumentTimeLabel.setForeground(Color.BLACK);
                ConsolePanel.this.currStatusLabel.setForeground(Color.BLACK);
                ConsolePanel.this.currOperationLabel.setForeground(Color.BLACK);
                ConsolePanel.this.monitorCountLabel1.setForeground(Color.BLACK);
                ConsolePanel.this.monitorCountLabel2.setForeground(Color.BLACK);
                ConsolePanel.this.detectorCountLabel1.setForeground(Color.BLACK);
                ConsolePanel.this.detectorCountLabel2.setForeground(Color.BLACK);
            }
        }
    }

    private class UpdateLogRunnable
    implements Runnable {
        private JiceEditorPane editorPane;
        private String data;
        private Logger logger;

        public UpdateLogRunnable(JiceEditorPane editorPane, String data) {
            this.editorPane = editorPane;
            this.data = data;
        }

        public UpdateLogRunnable(JiceEditorPane editorPane, String data, Logger logger) {
            this.editorPane = editorPane;
            this.data = data;
            this.logger = logger;
        }

        @Override
        public void run() {
            String line = String.valueOf(ConsolePanel.this.lineDateFormat.format(ConsolePanel.this.instrumentTime)) + "> " + this.data;
            if (this.editorPane != null) {
                if (line != null) {
                    this.editorPane.addLine(line);
                    this.editorPane.setCaretPosition(this.editorPane.getDocument().getLength());
                    if (this.logger != null) {
                        this.logger.info(line);
                    }
                    int componentCount = ConsolePanel.this.tabbedPane.getComponentCount();
                    int i = 0;
                    while (i < componentCount) {
                        Component comp = ((JScrollPane)ConsolePanel.this.tabbedPane.getComponentAt(i)).getViewport().getView();
                        if (comp == this.editorPane && i != ConsolePanel.this.tabbedPane.getSelectedIndex()) {
                            String title = ConsolePanel.this.tabbedPane.getTitleAt(i);
                            Matcher fontMatcher = ConsolePanel.this.fontPattern.matcher(title);
                            String newTitle = fontMatcher.replaceFirst("color=\"#ff0000\"");
                            ConsolePanel.this.tabbedPane.setTitleAt(i, newTitle);
                        }
                        ++i;
                    }
                }
            } else {
                this.logger.info("Editor pane null in UpdateLogRunnable");
            }
        }
    }
}

