/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.reportBugDialog;

import ice.Global;
import ice.gui.core.reportBugDialog.ButtonGroupPanelControl;
import ice.gui.core.reportBugDialog.InstrumentComboBox;
import ice.gui.core.reportBugDialog.exceptions.FieldsPanelUnsuportedInputType;
import ice.swing.EmailFormattedTextField;
import ice.swing.RequiredLabel;
import ice.swing.exceptions.EmptyRequiredFieldsException;
import ice.util.I18N;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FieldsPanel
extends JPanel {
    public static final String HEADLINE_TITLE_KEY = "ice.gui.core.reportBugDialog.controlsPanel.headlineLabel.title";
    public static final String SUBMITTER_EMAIL_TITLE_KEY = "ice.gui.core.reportBugDialog.controlsPanel.submitterEmailLabel.title";
    public static final String SUBMISSION_TYPE_TITLE_KEY = "ice.gui.core.reportBugDialog.controlsPanel.submissionTypeLabel.title";
    public static final String INSTRUMENT_SELECTED_TITLE_KEY = "ice.gui.core.reportBugDialog.controlsPanel.selectedInstrumentLabel.title";
    public static final String INSTRUMENT_OBSERVED_TITLE_KEY = "ice.gui.core.reportBugDialog.controlsPanel.observedInstrumentLabel.title";
    public static final String DESCRIPTION_TITLE_KEY = "ice.gui.core.reportBugDialog.controlsPanel.descriptionLabel.title";
    public static final String OBSERVED_INSTRUMENT_MAP = "ice.gui.core.reportBugDialog.instrumentOccurredMap";
    private static final long serialVersionUID = 1L;
    private JTextField headlineInput = null;
    private EmailFormattedTextField submitterEmail = null;
    private InstrumentComboBox instrumentInput = null;
    private String observedInstrument = null;
    private JTextArea description = null;
    private GridBagLayout gridBagLayout = null;
    private Hashtable<String, Boolean> requiredFields = null;
    private ButtonGroupPanelControl submissionTypeHolder = null;
    private static Logger logger = Logger.getLogger("ErrorLogger.FieldsPanel");

    public FieldsPanel() {
        this.init();
    }

    protected String getInputAsText(JComponent theField) throws EmptyRequiredFieldsException, FieldsPanelUnsuportedInputType {
        String returnValue = null;
        String theFieldsName = null;
        if (theField instanceof JTextField) {
            returnValue = ((JTextField)theField).getText().trim();
        } else if (theField instanceof JTextArea) {
            returnValue = ((JTextArea)theField).getText().trim();
        } else if (theField instanceof JComboBox) {
            returnValue = (String)((JComboBox)theField).getSelectedItem();
        } else if (theField instanceof JRadioButton) {
            returnValue = ((JRadioButton)theField).getText().trim();
        } else {
            throw new FieldsPanelUnsuportedInputType(theField);
        }
        theFieldsName = theField.getName();
        if (this.requiredFields.containsKey(theFieldsName)) {
            if (returnValue == null || returnValue.compareTo("") == 0) {
                throw new EmptyRequiredFieldsException(theField);
            }
        } else if (returnValue == null) {
            returnValue = "";
        }
        return returnValue;
    }

    public String getHeadline() throws EmptyRequiredFieldsException, FieldsPanelUnsuportedInputType {
        String returnValue = null;
        returnValue = this.getInputAsText(this.headlineInput);
        return returnValue;
    }

    public String getSubmitterEmail() throws EmptyRequiredFieldsException, FieldsPanelUnsuportedInputType {
        String returnValue = null;
        returnValue = this.getInputAsText(this.submitterEmail);
        return returnValue;
    }

    public boolean isEnhancement() throws EmptyRequiredFieldsException, FieldsPanelUnsuportedInputType {
        Component[] components;
        boolean returnValue = false;
        Component[] componentArray = components = this.submissionTypeHolder.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            AbstractButton button = (AbstractButton)comp;
            if (button.isSelected()) {
                String enhancementString = this.getInputAsText(button);
                return !enhancementString.equals("Bug");
            }
            ++n2;
        }
        return false;
    }

    public String getAffectedInstrument() throws EmptyRequiredFieldsException, FieldsPanelUnsuportedInputType {
        return this.instrumentInput.getInstrumentAffectedBugString();
    }

    public String getObservedInstrument() throws EmptyRequiredFieldsException, FieldsPanelUnsuportedInputType {
        return this.observedInstrument;
    }

    public String getDescription() throws EmptyRequiredFieldsException, FieldsPanelUnsuportedInputType {
        String returnValue = null;
        returnValue = this.getInputAsText(this.description);
        if (returnValue == null) {
            returnValue = "";
        }
        return returnValue;
    }

    private void add(String label, GridBagConstraints labelConstraints, JComponent theControl, GridBagConstraints controlConstraints, Boolean required) {
        JLabel jLabel = null;
        if (labelConstraints != null) {
            if (required.booleanValue()) {
                jLabel = new RequiredLabel(label);
                this.requiredFields.put(label, true);
            } else {
                jLabel = new JLabel(label);
            }
        }
        if (theControl instanceof JScrollPane) {
            int numberOfComponents = 0;
            Component subComponent = null;
            numberOfComponents = theControl.getComponentCount();
            assert (numberOfComponents > 0);
            subComponent = ((JScrollPane)theControl).getViewport().getView();
            subComponent.setName(label);
        } else {
            theControl.setName(label);
        }
        if (jLabel != null) {
            this.add((Component)jLabel, labelConstraints);
        }
        this.add((Component)theControl, controlConstraints);
    }

    private void buildGUI() {
        GridBagConstraints fieldConstraints = null;
        GridBagConstraints labelConstraints = null;
        Insets itemInset = null;
        JScrollPane scrollPane = null;
        String label = null;
        this.gridBagLayout = new GridBagLayout();
        this.setLayout(this.gridBagLayout);
        itemInset = new Insets(2, 5, 2, 5);
        fieldConstraints = new GridBagConstraints();
        fieldConstraints.fill = 2;
        fieldConstraints.anchor = 18;
        fieldConstraints.insets = itemInset;
        fieldConstraints.weightx = 1.0;
        fieldConstraints.weighty = 0.0;
        labelConstraints = new GridBagConstraints();
        labelConstraints.fill = 2;
        labelConstraints.anchor = 17;
        labelConstraints.insets = itemInset;
        labelConstraints.weightx = 0.0;
        labelConstraints.weighty = 0.0;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        this.headlineInput = new JTextField();
        this.headlineInput.setColumns(20);
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 0;
        label = I18N.getString(HEADLINE_TITLE_KEY);
        this.add(label, labelConstraints, this.headlineInput, fieldConstraints, true);
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 1;
        this.submitterEmail = new EmailFormattedTextField();
        this.submitterEmail.setColumns(20);
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 1;
        label = I18N.getString(SUBMITTER_EMAIL_TITLE_KEY);
        this.add(label, labelConstraints, this.submitterEmail, fieldConstraints, true);
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 2;
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 2;
        fieldConstraints.fill = 0;
        JRadioButton bugButton = new JRadioButton("Bug");
        bugButton.setSelected(true);
        JRadioButton enhButton = new JRadioButton("Enhancement");
        this.submissionTypeHolder = new ButtonGroupPanelControl();
        this.submissionTypeHolder.add(bugButton);
        this.submissionTypeHolder.add(enhButton);
        label = I18N.getString(SUBMISSION_TYPE_TITLE_KEY);
        this.add(label, labelConstraints, this.submissionTypeHolder, fieldConstraints, false);
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 3;
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 3;
        this.instrumentInput = new InstrumentComboBox();
        label = I18N.getString(INSTRUMENT_SELECTED_TITLE_KEY);
        this.add(label, labelConstraints, this.instrumentInput, fieldConstraints, false);
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 4;
        this.description = new JTextArea();
        this.description.setColumns(40);
        this.description.setRows(10);
        this.description.setLineWrap(true);
        fieldConstraints.gridx = 0;
        fieldConstraints.gridy = 5;
        fieldConstraints.fill = 1;
        fieldConstraints.gridwidth = 2;
        fieldConstraints.weightx = 1.0;
        fieldConstraints.weighty = 1.0;
        scrollPane = new JScrollPane(this.description);
        scrollPane.setHorizontalScrollBarPolicy(31);
        label = I18N.getString(DESCRIPTION_TITLE_KEY);
        this.add(label, labelConstraints, scrollPane, fieldConstraints, false);
    }

    private void init() {
        this.requiredFields = new Hashtable();
        String lookupName = "ice.gui.core.reportBugDialog.instrumentOccurredMap." + Global.getInstrumentName();
        this.observedInstrument = I18N.getString(lookupName);
        this.buildGUI();
    }
}

