/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.editorPanel;

import ice.Controller;
import ice.IconManager;
import ice.communication.SendQueueManager;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.Resource;
import ice.event.ModifyEvent;
import ice.event.ModifyListener;
import ice.event.ResourcePropertyChangedEvent;
import ice.event.ResourcePropertyChangedListener;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class ResourceTexteditor
extends JPanel
implements ResourcePropertyChangedListener {
    private JTextPane textPane = null;
    private JScrollPane scrollPane = null;
    private String resourceName = "";
    private IceFileType fileType = IceFileType.unknown;
    private ImageIcon icon;
    private boolean modified = false;
    private boolean unnamed = false;
    private boolean unloaded = false;
    private ArrayList<ModifyListener> modifyListeners = null;
    private Resource resource = null;
    private SendQueueManager sendManager = null;
    protected TextModifyListener textModifyListener;

    public ResourceTexteditor(Resource resource) {
        Controller controller = null;
        controller = Controller.getReference();
        this.resource = resource;
        this.sendManager = controller.getSendManager();
        this.buildGUI();
        this.fileType = resource.getFileType();
        this.resourceName = resource.getName();
        if (this.resourceName == null || this.resourceName.equals("")) {
            switch (this.fileType) {
                case scan: {
                    this.resourceName = "New scan" + this.getExtension();
                    this.icon = IconManager.getIcon("scan.generic");
                    break;
                }
                case sequence: {
                    this.resourceName = "New sequence" + this.getExtension();
                    this.icon = IconManager.getIcon("SequenceFileIcon");
                    break;
                }
                case pythonScript: {
                    this.resourceName = "New python script" + this.getExtension();
                    this.icon = IconManager.getIcon("PythonFileIcon");
                    break;
                }
                case xml: {
                    this.resourceName = "New XML file" + this.getExtension();
                    this.icon = new ImageIcon();
                    break;
                }
                case other: 
                case unknown: {
                    this.resourceName = "New file" + this.getExtension();
                    this.icon = new ImageIcon();
                }
            }
            this.unnamed = true;
            this.modified = true;
        } else {
            this.unnamed = false;
            this.modified = false;
        }
        String contents = resource.getContents();
        if (contents == null) {
            IceFile parent;
            contents = "";
            String parentName = "";
            String command = "";
            if (this.resource instanceof IceFile && (parent = ((IceFile)this.resource).getParent()) != null) {
                parentName = String.valueOf(parent.getName()) + ":";
            }
            try {
                resource.addPropertyChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("RootLogger").error("ResourceTexteditor  could not add listener " + e);
            }
            command = "Ask resourceFileContents File Get " + parentName + this.resourceName;
            this.sendManager.addMessage(command);
            this.unloaded = true;
        } else {
            this.unloaded = false;
        }
        this.setContents(contents);
    }

    public void buildGUI() {
        this.setName(this.resourceName);
        this.textPane = new JTextPane();
        this.textModifyListener = new TextModifyListener();
        this.textPane.getDocument().addDocumentListener(this.textModifyListener);
        this.modifyListeners = new ArrayList(10);
        this.scrollPane = new JScrollPane(this.textPane, 22, 30);
        this.scrollPane.setPreferredSize(new Dimension(1, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getExtension() {
        return this.fileType.getExtension();
    }

    public void setExtension(String extension) {
        IceFileType iceFileType = null;
        this.fileType = iceFileType = IceFileType.valueFromExtension(extension);
        this.resource.setFileType(this.fileType);
    }

    public void setContents(String contents) {
        if (this.textPane != null) {
            this.textPane.getDocument().removeDocumentListener(this.textModifyListener);
            this.textPane.setText(contents);
            this.textPane.getDocument().addDocumentListener(this.textModifyListener);
        }
    }

    public String getContents() {
        String returnValue = null;
        if (this.textPane != null) {
            returnValue = this.textPane.getText();
        }
        return returnValue;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.notifyModifyListeners();
    }

    public boolean isUnloaded() {
        return this.unloaded;
    }

    public void setUnloaded(boolean unloaded) {
        this.unloaded = unloaded;
    }

    public boolean isUnnamed() {
        return this.unnamed;
    }

    @Override
    public void actionPerformed(ResourcePropertyChangedEvent pce) {
        String propertyName = null;
        propertyName = pce.getPropertyName();
        if (propertyName != null && propertyName.equalsIgnoreCase("Contents")) {
            String newValue = null;
            newValue = (String)pce.getNewValue();
            if (newValue != null) {
                this.setContents(newValue);
            }
        }
    }

    public void saveResource(SendQueueManager sendManager, IceFile saveAsFile) {
        this.resource.removePropertyChangeListener(this);
        this.resource.setContents(null);
        this.resource = saveAsFile;
        try {
            this.resource.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("Resourcetexteditor.saveResource " + e);
        }
        this.saveResource(sendManager);
    }

    public void saveResource(SendQueueManager sendManager) {
        if (this.fileType.isAScanType()) {
            sendManager.addMessage("scan descrtolist \"" + this.resourceName + "\" " + this.textPane.getText());
        } else {
            IceFile parent;
            String contents = this.textPane.getText();
            String parentName = "";
            this.resource.setContents(contents);
            contents = contents.replaceAll("\"", "\\\\\"");
            if (this.resource instanceof IceFile && (parent = ((IceFile)this.resource).getParent()) != null) {
                parentName = String.valueOf(parent.getName()) + ':';
            }
            sendManager.addMessage("transfer \"" + parentName + this.resourceName + "\" \"" + contents + "\"");
        }
        this.unnamed = false;
        this.setModified(false);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void cutResource() {
        this.textPane.cut();
    }

    public void copyResource() {
        this.textPane.copy();
    }

    public void pasteResource() {
        this.textPane.paste();
    }

    public void selectAll() {
        this.textPane.selectAll();
    }

    public void selectNone() {
        this.textPane.select(0, 0);
    }

    public void addModifyListener(ModifyListener ml) {
        this.modifyListeners.add(ml);
    }

    public void removeModifyListener(ModifyListener ml) {
        this.modifyListeners.remove(ml);
    }

    private void notifyModifyListeners() {
        for (ModifyListener listener : this.modifyListeners) {
            listener.stateModified(new ModifyEvent(this, this.modified));
        }
    }

    private class TextModifyListener
    implements DocumentListener {
        private TextModifyListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            if (!ResourceTexteditor.this.modified) {
                ResourceTexteditor.this.setModified(true);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            if (!ResourceTexteditor.this.modified) {
                ResourceTexteditor.this.setModified(true);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            if (!ResourceTexteditor.this.modified) {
                ResourceTexteditor.this.setModified(true);
            }
        }
    }
}

