/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.controlPanel;

import ice.data.tas.bt7.Instrument;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ControlPanelFactory {
    private static final String BUNDLE_NAME = "ice.panel";
    private static final ResourceBundle rb = ResourceBundle.getBundle("ice.panel");
    private static final Logger logger = Logger.getLogger("StaticLogger");

    public static TreeMap<String, String> getPropertyMap(Instrument instrument) {
        TreeMap<String, String> propertyMap = new TreeMap<String, String>();
        int i = 0;
        String property = null;
        String key = null;
        do {
            if ((property = ControlPanelFactory.getProperty(key = String.valueOf(instrument.getName().toLowerCase()) + ".control.panel.item" + i++)) == null) continue;
            propertyMap.put(property, "N/A");
        } while (property != null);
        return propertyMap;
    }

    public static String getProperty(String key) {
        String property = null;
        try {
            property = rb.getString(key);
        }
        catch (MissingResourceException mre) {
            logger.error("Unable to find resource." + mre.getMessage());
        }
        catch (NullPointerException npe) {
            logger.error("The key is null." + npe.getMessage());
        }
        return property;
    }

    public static String getPropertyType(String key) {
        String propertyType = null;
        try {
            propertyType = rb.getString(key);
        }
        catch (MissingResourceException mre) {
            logger.error("Unable to find resource." + mre.getMessage());
        }
        catch (NullPointerException npe) {
            logger.error("The key is null." + npe.getMessage());
        }
        return propertyType;
    }

    public static boolean isEnabled(Instrument instrument) {
        String property = null;
        String key = null;
        key = String.valueOf(instrument.getName()) + ".control.panel.isEnabled";
        property = ControlPanelFactory.getProperty(key);
        return property == null || !property.equals("false");
    }
}

