/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.Controller;
import ice.data.tas.bt7.Instrument;
import ice.exceptions.ICECommandComboBoxException;
import ice.exceptions.IcePanelException;
import ice.gui.core.PlotPanel;
import ice.gui.panel.tas.PeakScanPanel;
import ice.gui.panel.tas.macs.LiveDataPanel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class IcePanelDataLoader {
    private static final String BUNDLE_NAME = "ice.panel";
    private static final ResourceBundle rb = ResourceBundle.getBundle("ice.panel");
    private static final Logger logger = Logger.getLogger("WidgetLogger.LiveDataLogger");
    private static Controller controller = Controller.getReference();
    private static String instrumentName;

    public static PlotPanel getLiveDataPanel() throws IcePanelException {
        PlotPanel panel = null;
        instrumentName = controller.getInstrument().getName();
        String key = String.valueOf(instrumentName.toUpperCase()) + ".livedata.panel";
        String location = IcePanelDataLoader.getValue(key);
        if (location == null) {
            panel = new LiveDataPanel();
        } else {
            try {
                Class<?> liveDataPanel = Class.forName(location);
                Class[] argType = new Class[]{Instrument.class};
                Constructor<?> constructor = liveDataPanel.getConstructor(new Class[0]);
                panel = (PlotPanel)constructor.newInstance(new Object[0]);
            }
            catch (SecurityException e) {
                logger.error(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage());
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
            }
            catch (InvocationTargetException e) {
                logger.error(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
            }
        }
        return panel;
    }

    public static PlotPanel getPeakScanPanel() throws ICECommandComboBoxException, IcePanelException {
        PlotPanel panel = null;
        instrumentName = controller.getInstrument().getName();
        String key = String.valueOf(instrumentName.toUpperCase()) + ".peakscan.panel";
        String location = IcePanelDataLoader.getValue(key);
        if (location == null) {
            panel = new PeakScanPanel();
        } else {
            try {
                Class<?> peakScanPanel = Class.forName(location);
                Constructor<?> constructor = peakScanPanel.getConstructor(new Class[0]);
                panel = (PlotPanel)constructor.newInstance(new Object[0]);
            }
            catch (SecurityException e) {
                logger.error(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage());
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
            }
            catch (InvocationTargetException e) {
                logger.error(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
            }
        }
        return panel;
    }

    public static String getValue(String key) {
        String location = null;
        try {
            location = rb.getString(key);
        }
        catch (MissingResourceException mre) {
            logger.error("Unable to find resource." + mre.getMessage());
        }
        catch (NullPointerException npe) {
            logger.error("The key is null." + npe.getMessage());
        }
        return location;
    }

    public static ArrayList<String> getValues(String key) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        String counterName = null;
        do {
            if ((counterName = IcePanelDataLoader.getValue(String.valueOf(key) + i++)) == null) continue;
            list.add(counterName);
        } while (counterName != null);
        return list;
    }
}

