/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.exceptions.ICECommandComboBoxException;
import java.util.HashMap;
import javax.swing.JComboBox;

public class ICECommandComboBox
extends JComboBox {
    private HashMap<String, String> displayNameToCommandStringMap;

    public ICECommandComboBox(String[] displayNames, String[] commandStrings) throws ICECommandComboBoxException {
        super(displayNames);
        int index = 0;
        if (displayNames.length != commandStrings.length) {
            throw new ICECommandComboBoxException("Number of display strings does not match number of command strings.");
        }
        this.displayNameToCommandStringMap = new HashMap();
        String[] stringArray = displayNames;
        int n = displayNames.length;
        int n2 = 0;
        while (n2 < n) {
            String displayName = stringArray[n2];
            this.displayNameToCommandStringMap.put(displayName, commandStrings[index]);
            ++index;
            ++n2;
        }
    }

    public String getCommandString() {
        String displayString = (String)this.getSelectedItem();
        String commandString = this.displayNameToCommandStringMap.get(displayString);
        return commandString;
    }
}

