/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.Controller;
import ice.IconManager;
import ice.event.StartUpEvent;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceWindow;
import ice.swing.Bag;
import ice.swing.IceTextField;
import ice.swing.actions.IceMenuAction;
import ice.util.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public abstract class GenericIcePanel
extends JPanel
implements ClipboardOwner {
    private static ImageIcon warningIcon = IconManager.getIcon("warning16x16");
    private static ImageIcon errorIcon = IconManager.getIcon("error16x16");
    private static Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private ImageIcon icon;
    protected boolean locked;
    protected JPanel statusPanel;
    protected JLayeredPane layeredStatusPane;
    protected JPanel cursoryStatusBar;
    protected LinkedHashMap<Component, JPanel> warningMessages;
    protected LinkedHashMap<Component, JPanel> errorMessages;
    private int nextWarningNum = 33;
    private int nextErrorNum = 99;
    protected boolean initOK;

    protected GenericIcePanel() {
        this.initGenericIcePanel();
    }

    protected GenericIcePanel(String name) {
        this.setName(name);
        this.initGenericIcePanel();
    }

    public boolean panelHandlesScrollBar() {
        return false;
    }

    public IceWindow getIceWindowParent() {
        IceWindow parentWindow = null;
        IceWindow container = null;
        container = (IceWindow)this.getFinalParent();
        if (container instanceof IceWindow && container != null) {
            parentWindow = container;
        }
        return parentWindow;
    }

    public void bringPanelToFront() {
        IceWindow parentWindow = null;
        parentWindow = this.getIceWindowParent();
        parentWindow.toFront();
        parentWindow.selectPanel(this);
    }

    public void panelAddedToWindow() {
    }

    public void panelRemovedFromWindow() {
    }

    public void saveSettings() throws IcePanelException {
    }

    private void initGenericIcePanel() {
        this.icon = IconManager.getIcon(this);
        String message = "Processing " + this.getName() + "...";
        StartUpEvent load = new StartUpEvent((Object)this, message);
        Controller.getReference().notifyStartUpListeners(load);
        this.locked = false;
        this.warningMessages = new LinkedHashMap();
        this.errorMessages = new LinkedHashMap();
        this.initOK = true;
        this.buildStatusPanel();
    }

    private void buildStatusPanel() {
        this.statusPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 3));
        this.layeredStatusPane = new IceLayeredPane();
        this.layeredStatusPane.setPreferredSize(new Dimension(10, 16));
        JPanel emptyStatusBar = new JPanel(new FlowLayout(0, 0, 0));
        JLabel label = new JLabel("Messages:");
        emptyStatusBar.add(label);
        this.layeredStatusPane.add((Component)emptyStatusBar, new Integer(0));
        label.setText("Panel " + this.getName());
        this.statusPanel.add(this.layeredStatusPane);
    }

    public boolean isInitilized() {
        return this.initOK;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    protected void throwErrorDialog(String title, String message) {
        JButton okBtn = new JButton("OK");
        Object[] options = new Object[]{okBtn};
        JOptionPane optionPane = new JOptionPane(message, 0, -1, (Icon)UIManager.get("OptionPane.errorIcon"), options);
        final JDialog errorDialog = new JDialog((IceWindow)this.getFinalParent());
        errorDialog.setTitle(title);
        errorDialog.setModal(true);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                errorDialog.dispose();
            }
        });
        errorDialog.setDefaultCloseOperation(2);
        errorDialog.setContentPane(optionPane);
        errorDialog.pack();
        errorDialog.setLocationRelativeTo(this);
        errorDialog.setVisible(true);
    }

    protected void throwConfirmDialog(String title, String message, ArrayList<JButton> btns) {
        final JDialog confirmDialog = new JDialog((IceWindow)this.getFinalParent());
        confirmDialog.setTitle(title);
        confirmDialog.setModal(true);
        confirmDialog.setDefaultCloseOperation(2);
        Iterator<JButton> iterator = btns.iterator();
        while (iterator.hasNext()) {
            iterator.next().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    confirmDialog.dispose();
                }
            });
        }
        JOptionPane optionPane = new JOptionPane(message, 3, 2, UIManager.getIcon("OptionPane.questionIcon"), btns.toArray());
        confirmDialog.setContentPane(optionPane);
        confirmDialog.pack();
        confirmDialog.setLocationRelativeTo(this);
        confirmDialog.setVisible(true);
    }

    public boolean panelClosing() {
        return true;
    }

    public JPanel getStatusBar() {
        return this.statusPanel;
    }

    public IceMenuAction getIceMenuAction(String actionName) {
        return new IceMenuAction(actionName);
    }

    public void setLocked(boolean lockMode) {
        this.locked = lockMode;
        this.updateLockState();
    }

    public boolean isLocked() {
        return this.locked;
    }

    protected void updateLockState() {
    }

    protected void appendWarningMessage(Component comp, String message) {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel(warningIcon));
        panel.add(Box.createRigidArea(new Dimension(1, 0)));
        panel.add(new JLabel(message));
        int layer = this.nextWarningNum--;
        if (this.warningMessages.containsKey(comp)) {
            JPanel currPanel = this.warningMessages.get(comp);
            layer = this.layeredStatusPane.getLayer(currPanel);
            this.layeredStatusPane.remove(currPanel);
        }
        this.warningMessages.put(comp, panel);
        this.layeredStatusPane.add((Component)panel, new Integer(layer));
        this.layeredStatusPane.revalidate();
        --this.nextWarningNum;
    }

    protected void appendErrorMessage(Component comp, String message) {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel(errorIcon));
        panel.add(Box.createRigidArea(new Dimension(1, 0)));
        panel.add(new JLabel(message));
        int layer = this.nextErrorNum--;
        if (this.errorMessages.containsKey(comp)) {
            JPanel currPanel = this.errorMessages.get(comp);
            layer = this.layeredStatusPane.getLayer(currPanel);
            this.layeredStatusPane.remove(currPanel);
        }
        this.errorMessages.put(comp, panel);
        this.layeredStatusPane.add((Component)panel, new Integer(layer));
        this.layeredStatusPane.revalidate();
    }

    protected void removeWarningMessage(Component comp) {
        if (!this.warningMessages.containsKey(comp)) {
            return;
        }
        JPanel panel = (JPanel)this.warningMessages.remove(comp);
        int lostLayerIndex = JLayeredPane.getLayer(panel);
        this.layeredStatusPane.remove(panel);
        Component[] components = this.layeredStatusPane.getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            int layerIndex = this.layeredStatusPane.getLayer(component);
            if (layerIndex > lostLayerIndex) {
                this.layeredStatusPane.setLayer(component, layerIndex - 1);
            }
            ++i;
        }
        this.layeredStatusPane.repaint();
        ++this.nextWarningNum;
    }

    protected void removeErrorMessage(Component comp) {
        if (!this.errorMessages.containsKey(comp)) {
            return;
        }
        JPanel panel = (JPanel)this.errorMessages.remove(comp);
        int lostLayerIndex = JLayeredPane.getLayer(panel);
        this.layeredStatusPane.remove(panel);
        Component[] components = this.layeredStatusPane.getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            int layerIndex = this.layeredStatusPane.getLayer(component);
            if (layerIndex > lostLayerIndex) {
                this.layeredStatusPane.setLayer(component, layerIndex - 1);
            }
            ++i;
        }
        this.layeredStatusPane.repaint();
        ++this.nextErrorNum;
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClipboardContents(Transferable contents) {
        Clipboard clipboard = GenericIcePanel.clipboard;
        synchronized (clipboard) {
            GenericIcePanel.clipboard.setContents(contents, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transferable getClipboardContents() {
        Clipboard clipboard = GenericIcePanel.clipboard;
        synchronized (clipboard) {
            return GenericIcePanel.clipboard.getContents(this);
        }
    }

    public Container getFinalParent() {
        Container container = this.getParent();
        if (container != null) {
            while (container.getParent() != null) {
                container = container.getParent();
            }
        }
        return container;
    }

    public static JPanel createHeaderPanel(String title, String instructions) {
        JPanel headerPanel = new JPanel();
        Bag constraints = new Bag();
        Insets insets = new Insets(0, 5, 0, 5);
        String formattedTitle = "<html><font size=\"+1\">" + title + "</font></html>";
        JLabel titleLabel = new JLabel(formattedTitle);
        JLabel instructionsLabel = new JLabel(instructions);
        constraints.inset(insets);
        headerPanel.setLayout(new GridBagLayout());
        headerPanel.setBackground(Color.WHITE);
        headerPanel.add((Component)titleLabel, constraints.cell(0, 0));
        headerPanel.add((Component)instructionsLabel, constraints.cell(0, 1));
        return headerPanel;
    }

    public boolean determineNonNegativeNumberValidityWithDialog(Map<IceTextField, String> map) {
        boolean allValid = true;
        String errorMsg = I18N.getString("invalidNonNegativeNumberError");
        StringBuilder invalidFields = new StringBuilder();
        for (IceTextField field : map.keySet()) {
            if (field.containsNonNegativeNumber()) continue;
            allValid = false;
            invalidFields.append(", " + map.get(field));
        }
        if (allValid) {
            return true;
        }
        errorMsg = errorMsg.concat(invalidFields.substring(2));
        this.throwErrorDialog(I18N.getString("invalidNumber.title"), errorMsg);
        return false;
    }

    protected void handleIcePanelException(String panelName, Throwable e) throws IcePanelException {
        throw new IcePanelException(String.valueOf(panelName) + " Panel cannot be loaded", e);
    }

    public boolean requestFocusInIceWindow() {
        return false;
    }

    public abstract class ConfirmableAction
    extends AbstractAction {
        public ConfirmableAction(String name) {
            super(name);
        }

        protected ArrayList<JButton> createOkCancelBtns() {
            JButton okBtn = new JButton("OK");
            okBtn.addActionListener(new ConfirmAction());
            JButton cancelBtn = new JButton("Cancel");
            cancelBtn.addActionListener(new DeclineAction());
            ArrayList<JButton> btns = new ArrayList<JButton>();
            btns.add(okBtn);
            btns.add(cancelBtn);
            return btns;
        }

        protected abstract void confirmed();

        protected abstract void declined();

        protected class ConfirmAction
        implements ActionListener {
            protected ConfirmAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConfirmableAction.this.confirmed();
            }
        }

        protected class DeclineAction
        implements ActionListener {
            protected DeclineAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConfirmableAction.this.declined();
            }
        }
    }

    private class IceLayeredPane
    extends JLayeredPane {
        private IceLayeredPane() {
        }

        @Override
        public void revalidate() {
            super.revalidate();
            this.updateStatusPanelSize();
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.updateStatusPanelSize();
        }

        private synchronized void updateStatusPanelSize() {
            int x = 1;
            int y = 0;
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.getBorder() != null) {
                Insets insets = this.getBorder().getBorderInsets(this);
                x += insets.left;
                y += insets.top;
                width -= insets.left + insets.right;
                height -= insets.top + insets.bottom;
            }
            Component[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                components[i].setBounds(x, y, width, height);
                ++i;
            }
        }
    }
}

